 #
 # This file is part of the Anotatornia suite.
 # 
 # Copyright © 2007, 2008, 2009, 2010 by Instytut Podstaw Informatyki
 # Polskiej Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 # Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 # 
 # This file may be distributed and/or modified under the terms of the
 # GNU General Public License version 3 as published by the Free Software
 # Foundation and appearing in the file COPYING included in the packaging
 # of this file.  (See http://www.gnu.org/licenses/translations.html for
 # unofficial translations.)
 # 
 # A commercial license is available from IPI PAN (contact
 # Michal.Ciesiolka.waw.pl or ipi.waw.pl for more
 # information).  Licensees holding a valid commercial license from IPI
 # PAN may use this file in accordance with that license.
 # 
 # This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 # THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 # PURPOSE.
 #

class AuxController < ApplicationController
  layout 'admin'

  before_filter :authorize
  before_filter :update_activity_time

  def sensy
    @nounsenses = senses_arr( 'noun' )
    @verbsenses = senses_arr( 'verb' )
  end


  private

  def senses_arr( ksem )
    [['lemat', 'sens_opis', 'anot_ct', 'zweryf_ct'].
      collect{|hd| "<b>#{hd}</b>"}] +
    SensySensemu.find(:all, :conditions => {:klasa_sem => ksem } ).
      collect{|ss|
      if ss.nowy?
        nowy = " (n)"
      else nowy = ""
      end
      [ss.lemat, ss.sens_opis, 
       "#{ss.sens_anot_count}#{nowy}", 
       "#{ss.sens_zweryf_count}#{nowy}"]
    }.sort
  end # of senses_arr
  

end
