 #
 # This file is part of the Anotatornia suite.
 # 
 # Copyright © 2007, 2008, 2009, 2010 by Instytut Podstaw Informatyki
 # Polskiej Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 # Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 # 
 # This file may be distributed and/or modified under the terms of the
 # GNU General Public License version 3 as published by the Free Software
 # Foundation and appearing in the file COPYING included in the packaging
 # of this file.  (See http://www.gnu.org/licenses/translations.html for
 # unofficial translations.)
 # 
 # A commercial license is available from IPI PAN (contact
 # Michal.Ciesiolka.waw.pl or ipi.waw.pl for more
 # information).  Licensees holding a valid commercial license from IPI
 # PAN may use this file in accordance with that license.
 # 
 # This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 # THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 # PURPOSE.
 #

class LogowanieController < ApplicationController
  
  layout "admin"

  before_filter :authorize, :except => :logowanie
  before_filter :update_activity_time, :except => [:session_expiry, :logowanie]

#  ssl_required :logowanie
  
  def logowanie
#    session[:uzid] = nil
    reset_session
    if request.post?
      # obrabiamy logowanie w~dragu
      logins = params[:login].split
      # Superanotator może się zalogować jako dowolna anotatorka, i~wówczas może tylko oglądać.
      login = logins[0]
      uzytkownik = Uzytkownik.authenticate(login, params[:haslo])

      if uzytkownik and uzytkownik != :zablokowany
        
        set_u4session = Proc.new { |u|
          session[:uzid] = u.id
          session[:rola_id] = u.rola_id
          session[ :jak_anotator ] = u.jak_anotator?
          session[ :tylko_nowe_komentarze_ogladactwo ] = 
          u.tylko_nowe_komentarze_ogladactwo?
          session[ :tylko_nowe_komentarze_anotacja ] = 
          u.tylko_nowe_komentarze_anotacja?
        }
        set_u4session.call( uzytkownik )
        

        if r_wszewid? and logins.size > 1
          dq_id = uzytkownik.id
          uzytkownik = Uzytkownik.find_by_login( logins[-1] )
          if uzytkownik and uzytkownik.anotator?
            session[ :login ] = "#{login} jako #{logins[-1]}"
            session[ :drag_queen_id ] = dq_id
            set_u4session.call( uzytkownik )
          else
            flash[ :notice ] = "Nie ma <b>anotatora</b> #{logins[-1]}, loguję Cię jako #{login}."
          end
        else
          session[ :login ] = login
        end


        logger.info "@@@@ #{session[:login]} logged in at #{Time.now.to_s(:db)}"
#        uri = session[:original_uri]
#        session[:original_uri] = nil
        if r_anotator?
          redirect_to :controller => annotation_controller, # application helper
          :action => 'lista_transz'
        elsif Rola.wszewid?(session[:rola_id]) or Rola.gosc?(session[:rola_id])
          redirect_to :controller => annotation_controller, :action => 'ogladactwo'
        else  redirect_to(# uri || 
                          { :action => "index" })
        end

      elsif uzytkownik == :zablokowany
        flash[:notice] = "Twoje konto zostało zablokowane. <br> Skontaktuj się z administratorem."
      else
        flash[:notice] = "Nietrafna kombinacja login/hasło"
      end
    end
  end # of #{logowanie}
  

  def wylogowanie
#    session[:uzid] = nil
#    session[:rola_id] = nil
    logger.info "@@@@ #{Uzytkownik.find(session[:uzid]).login} logged out at #{Time.now.to_s(:db)}"
    reset_session
    if flash[:notice]
      flash[:notice]=flash[:notice]
    else
      flash[:notice] = "Wylogowałeś/aś się"
    end
    redirect_to(:action => "logowanie" )
  end

  def index
  end


  def session_expiry
    @time_left = (session[:expires_at] - Time.now).to_i
    if @time_left < 1.minute
      render :update do |page| 
        page.replace_html 'expiry', :partial => 'session_expiry', :object => @time_left
      end
    end
    unless @time_left>0
      flash[:notice] = "Twoja sesja wygasła. Proszę, zaloguj się."
#      render do |page| 
#        page << "window.location = '#{url_for(:controller => "logowanie" , :action => "wylogowanie" )}';"
#      end
#      render  '/logowanie/redirect'
      reset_session
#      redirect_to(:controller => "logowanie" , :action => "wylogowanie" )
    end
  end




end
