 #
 # This file is part of the Anotatornia suite.
 # 
 # Copyright © 2007, 2008, 2009, 2010 by Instytut Podstaw Informatyki
 # Polskiej Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 # Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 # 
 # This file may be distributed and/or modified under the terms of the
 # GNU General Public License version 3 as published by the Free Software
 # Foundation and appearing in the file COPYING included in the packaging
 # of this file.  (See http://www.gnu.org/licenses/translations.html for
 # unofficial translations.)
 # 
 # A commercial license is available from IPI PAN (contact
 # Michal.Ciesiolka.waw.pl or ipi.waw.pl for more
 # information).  Licensees holding a valid commercial license from IPI
 # PAN may use this file in accordance with that license.
 # 
 # This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 # THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 # PURPOSE.
 #

Uzytkownik.find( :first ) # żeby utworzyć Natrorów, gdyby ich nie było.

class SuperanotacjaController < AnotacjaController

  before_filter :check_zarzadca

##  skip_before_filter :check_edytowalny, :only => [ :skomentowane_tylko_nowe_przełącz,
    ##                                               :skomentowane_przełącz]
## wygląda na to, że zastępuje klauzulę #:except filtra klasy rodzicielskiej. Więc robię rzecz mocno nieelegancką: dopisuję symbole tych metod w~klasie rodzicielskiej.
  
  before_filter :check_edytowalny, :except => EDYTOWALNY_EXCEPTIONS + [
                                                                       :skomentowane_tylko_nowe_przełącz, 
                                                                       :skomentowane_tylko_nowe_anotacja_przełącz, 
                                                                       :skomentowane_przełącz, :komentarz_nowy_przełącz,
                                                                       :odbierz_transze_bprosby, 
                                                                       :odebrania_bp_ukryj, :odebrania_bp_pokaz
                                                                      ]



  def nowa_dyzambiguacja
    set_uzid
    intid=params[ :interpretacja_anot ]

    if intid
      intid=intid[:interpretacja_id].to_i
      tok = Interpretacja.find( intid ).token
      @tokid = tok.id
      @interpretacja_anot=InterpretacjaAnot.find(
                                                 :first,
                                                 :conditions => {
                                                   :akapit_transzy_id => akapit_transzy.id, # to jest dobrze, to jest akat przekazany w~parametrach.
                                                   :token_id => @tokid
                                                 })
      @interpretacja_anot ||= InterpretacjaAnot.new
      @interpretacja_anot.interpretacja_id = intid
      @interpretacja_anot.uzytkownik_id=@uzid
      @interpretacja_anot.akapit_transzy_id = akapit_transzy.id
      @interpretacja_anot.token_id = @tokid
      InterpretacjaAnot.transaction do
        @interpretacja_anot.save!
        @interpretacja_anot.skopiuj_na_bliźniaczą # nyhet
        if DlaEli.nk
          obniz_status( akapit_transzy, :morphosyntactic)
          tok.odsmiec_interpretacje 
        else
          obniz_status( akapit_transzy )
        end
      end
    else# not intid
      @tokid=params[:id].to_i
    end
#    redirect_to :action => 'anotuj' # for debug
    raiseifzero( @tokid, "nowa_dyzambiguacja" )
    if ( szd = session[ :zmieniaj_dyzamb ] ) and szd[ @tokid ]
      szd[ @tokid ] = nil
    end
    zdeweryfikuj( :morphosyntactic, @tokid )
    odswiez_bitoken( @tokid )
  end # of #{nowa_dyzambiguacja}.


  def morfoskładnia_zatwierdź_tę
    set_uzid
    
    tok = Token.find( params[:id] )
    @tokid = tok.id
    @ia=InterpretacjaAnot.find(
                                               :first,
                                               :conditions => {
                                                 :akapit_transzy_id => akapit_transzy.id,
                                                 :token_id => @tokid
                                               })
    @ia ||= InterpretacjaAnot.new
    changée = @ia.new_record?
    dis_id = params[ :disamb_id ].to_i
    if @ia.interpretacja_id != dis_id
      @ia.interpretacja_id = dis_id 
      changée = true
    end
    if changée
      @ia.uzytkownik_id=@uzid
      @ia.akapit_transzy_id = akapit_transzy.id
      @ia.token_id = @tokid
    end
    InterpretacjaAnot.transaction do
      @ia.save! if changée
      @ia.skopiuj_na_bliźniaczą 
      obniz_status( akapit_transzy, :morphosyntactic)
      tok.odsmiec_interpretacje 
    end # of transaction
    
    raiseifzero( @tokid, "nowa_dyzambiguacja" )
    if ( szd = session[ :zmieniaj_dyzamb ] ) and szd[ @tokid ]
      szd[ @tokid ] = nil
    end
    zdeweryfikuj( :morphosyntactic, @tokid )
    odswiez_bitoken( @tokid )
  end # of #{morfoskładnia_zatwierdź_tę}.


  def self.zaślepka( meth )
    eval "def #{meth}
raise \"zaślepka\"
end
"
  end # of #zaślepka


  def wybor_sensu # wołana z \file{_token_wybs.rhtml}
    set_uzid
    akat_hash # inicjuje #{@akat_hash}, jeśli jej nie było
    obniz_status( @akapit_transzy, :word_senses )
    sensid = params[ :the_sens ]
    tokid = params[ :id ].to_i
    disaid = params[ :disamb_id ].to_i
    raiseifzero( tokid, "wybor_sensu")

    if sensid and sensid[:sensy_id] and 
        sensid[:sensy_id].to_i != 0
      # drugi człon koniunkcji na wypadek, 
      #gdyby nic nie wybrano, ale to i tak mało
      sensid=sensid[ :sensy_id ].to_i

      [ @akapit_transzy, @akat_bliźniak ].each { |at190|
        @sens_anot = SensAnot.znajdz( tokid, at190.akat_hash )
        @sens_anot ||= SensAnot.new
        @sens_anot.sensy_id = sensid
        @sens_anot.uzytkownik_id = @uzid
        @sens_anot.akapit_transzy_id = at190.id
        @sens_anot.interpretacja_id = disaid
        @sens_anot.token_id = tokid
        @sens_anot.automatycznie = false
        sl187 = @sens_anot.sensy( :refresh )
        if sl187
          @sens_anot.save!
        else
          @sens_anot = nil
        end
      }
    end  # of  sensid and sensid[:sensy_id] and sensid[:sensy_id].to_i != 0
    zdeweryfikuj( :word_senses, tokid )
    odswiez_bitoken(tokid, :tylko_sens)
  end # of wybor_sensu


  zaślepka :fraza_upuszczono


  def frazy_wyczysc
    akat = akapit_transzy
    AkapitTranszy.transaction do
      obniz_status( akat )      
      akat.fraza_anot.delete_all
      @akat_bliźniak.fraza_anot.delete_all # nyhet
    end
    
    redirect_to :action => :anotuj, :akat => akat, :anchor => :primafalsa
  end # of #frazy_wyczysc

  zaślepka :fraza_wyczysc
  zaślepka :fraza_ukryj_typ
  zaślepka :fraza_wybor_typu
  zaślepka :fraza_glowy_ukryj
  zaślepka :fraza_synh_ukryj
  zaślepka :fraza_semh_ukryj  
  zaślepka :fraza_dwie_glowy
  zaślepka :fraza_wybor_glowy
  zaślepka :fraza_sie_typ_ukryj
  zaślepka :fraza_sie_typ_wybor


  def interpretacja_z_tagu
    set_uzid
    @tokid = params[:id].to_i
    tagparam = "token_tag#{@tokid}".intern
    lematparam="token_lemat#{@tokid}".intern
    tag = params[tagparam][:tag]
    lemat = params[lematparam][:lemat]
    ct  = Tagset.check_tag( tag, lemat )
    if ct[0]
      iid = Interpretacja.fc_by_fulltag( @tokid, lemat, tag ).id
      conds = { 
        :akapit_transzy_id => akapit_transzy.id,
        :token_id => @tokid
      }
      ia = InterpretacjaAnot.find( :first, :conditions => conds )
      ia ||= InterpretacjaAnot.new( conds )
      ia.uzytkownik_id = @uzid
      ia.interpretacja_id = iid
      ia.save!
      ia.skopiuj_na_bliźniaczą # nyhet
      Interpretacja.odsmiec( :token_id => @tokid )
      
      if ( szd = session[ :zmieniaj_dyzamb ] ) and szd[ @tokid ]
        szd[@tokid] = nil
      end
      zdeweryfikuj( :morphosyntactic, @tokid )
      odswiez_bitoken( @tokid )
    else  flash.now[:tworz_tag] = ct[1]
      session[ :tworz_tag ] ||= Hash.new
        session[ :tworz_tag ][ @tokid ] = { :lemat => lemat, :tag => tag }
      odswiez_token( @tokid, :tworz_tag )
    end
  end# of #{interpretacja_z_tagu}.

  # #nowytag_skopiuj_orth jest O.K. w~oryginale


  def segmentacja_ujednoznacznij
    set_poziomy
    segdec=params[:sg_variant_anot]
    ##      logger.info( "@@@@ segdec: #{segdec}, class: #{segdec.class}" )
    session[:zmieniaj_segmentacje] ||= Hash.new
    if segdec
      segdec=segdec[ :wybierz ].to_bool
      tokid = params[:id].to_i
      token = Token.find( tokid )
      sg_choice = token.sg_choice
      sgvid = token.sg_variant_id
      sguj_tokids = []
      SgVariantAnot.transaction do
        sg_choice.sg_variant.each{ |sgv|
          sgv_cond = {
            :akapit_transzy_id => akapit_transzy.id,
            :sg_choice_id => sg_choice.id,
            :sg_variant_id => sgv.id
          }
          sgvan = SgVariantAnot.find(
                                     :first,
                                     :conditions => sgv_cond)
          sgvan ||= SgVariantAnot.new( sgv_cond )
          sgvan.chosen = (( sgv.id == sgvid ) == ( segdec == true ))
          sgvan.save!
          sgvan.skopiuj_na_bliźniaczy # nyhet
          sgv.token.each{ |tok| sguj_tokids << tok.id }
        }# of each segm. variant
        obniz_status( akapit_transzy, :segmentation )
      end# of transaction
    else# #{not intid}
      sguj_tokids = [ params[:id].to_i ]
    end
    # #{    redirect_to :action => 'anotuj'} for debug
    sguj_tokids.each{ |tokid|
      raiseifzero( tokid, "segmentacja_ujednoznacznij" )
      session[ :zmieniaj_segmentacje][ tokid ] = nil }
    
    zdeweryfikuj( :segmentation, sguj_tokids )
    odswiez_bitoken( sguj_tokids, :segmentation )
    
  end # of #{segmentacja_ujednoznacznij}.

  def segmentacja_zatwierdź_tę
    set_poziomy
    tokid = params[:id].to_i
    token = Token.find( tokid )
    sg_choice = token.sg_choice
    sguj_tokids = []
    SgVariantAnot.transaction do
      sg_choice.sg_variant.each{ |sgv|
        sgv_cond = {
          :akapit_transzy_id => akapit_transzy.id,
          :sg_choice_id => sg_choice.id,
          :sg_variant_id => sgv.id
        }
        sgvan = SgVariantAnot.find(
                                   :first,
                                   :conditions => sgv_cond)
        
        sgvan.skopiuj_na_bliźniaczy # nyhet
        sgv.token.each{ |tok| sguj_tokids << tok.id }
      }# of each segm. variant
      obniz_status( akapit_transzy, :segmentation )
    end# of transaction
  
    sguj_tokids.each{ |tokid|
      raiseifzero( tokid, "segmentacja_ujednoznacznij" )
      if session[ :zmieniaj_segmentacje ]
        session[ :zmieniaj_segmentacje][ tokid ] = nil 
      end
}
    
    zdeweryfikuj( :segmentation, sguj_tokids )
    odswiez_bitoken( sguj_tokids, :segmentation )
    
  end # of #{segmentacja_zatwierdź_tę}.
 

  def konczymy_zdanie
    @tokid=params[ :id ].to_i
    set_poziomy
    akat=akapit_transzy
    kz = KoniecZdaniaAnot.znajdz( akat, @tokid )

    if kz
      kz.zniszcz_oba
    else  
      KoniecZdaniaAnot.zrób_oba( 
                              :akat => akat,
                              :uzytkownik_id => @uzid,
                              :token_id => @tokid
                              )
    end
    zdeweryfikuj( :sentences, @tokid )
    odswiez_bitoken( @tokid, :sentences )
  end # of #{konczymy_zdanie}.


  def word_senses_zatwierdź_tę
    set_poziomy
    tokid = params[:id].to_i
    akat190 = AkapitTranszy.find( params[ :akat ].to_i )
    akath190 = akat190.akat_hash
    tok190 = Token.find( tokid )
    the_sens190 = tok190.the_sens( akath190 ).id
    tsa190 = tok190.sens_anot
    SensAnot.transaction do
      tsa190.each{ |sa190|
        unless sa190.sensy_id == the_sens190
          sa190.sensy_id = the_sens190
          sa190.save!
        end}
      
      if tsa190.size < 2
        sa190 = SensAnot.create!(
          :sensy_id => the_sens190,
          :uzytkownik_id => @uzid,
          :akapit_transzy_id => akat190.blizniaczy_id,
          :interpretacja_id => tok190.do_sensu?( akath190 ),
          :token_id => tok190.id,
          :automatycznie => false )
      end
      
      obniz_status( akat190, :word_senses )
    end# of transaction
  
    zdeweryfikuj( :word_senses, tok190.id )
    odswiez_bitoken( tok190.id, :tylko_sens )
    
  end # of #{word_senses_zatwierdź_tę}.


  def skomentowane_przełącz
    session[:skomentowane_pokaż] = (not session[:skomentowane_pokaż])
    if ptn = params[:tylko_nowe]
      ustaw_tylko_nowe_komentarze_ogladactwo( ptn.to_bool )
    end
    render_skomentowane
  end # of #skomentowane_przełącz


  def skomentowane_tylko_nowe_przełącz
    ustaw_tylko_nowe_komentarze_ogladactwo( 
                                           (not session[:tylko_nowe_komentarze_ogladactwo]) )
    render_skomentowane
  end #of #skomentowane_tylko_nowe_przełącz


  def skomentowane_tylko_nowe_anotacja_przełącz  
    ustaw_tylko_nowe_komentarze_anotacja( 
                                           (not session[:tylko_nowe_komentarze_anotacja]) )
    render_komentarze
  end 


  def komentarz_nowy_przełącz
    ko = Komentarz.find( params[:id] )
    ko.nowy = ( not ko.nowy? )
    ko.save!
    render :update do |page| 
      page.replace( "komentarz_ballot-#{ko.id}",
                    :partial => 'komentarz_ballot', :object => ko
                    )
    end # of #render
  end # of #komentarz_nowy_przełącz

  # #spełnij_prośbę i #odrzuć_prośbę przeniesione do #{AnotacjaController}, by miał do nich dostęp audytor.

  
  def odbierz_transze_bprosby
    ti = params[:transza_odbierana][:numer].to_i
    if t = Transza.find_by_transza_id(ti)
      ui=t.uzytkownik_id
    end
    if ti and ui
      params[:id] = ProsbyAnotatorek.create( 
                                            :dotyczy_id => ti,
                                            :dotyczy_type => "Transza",
                                            :uzytkownik_id => ui,
                                            :opis => "odebrana z inicjatywy Zarządcy"
                                            ).id
    end
    refresh_prośby
  end # of  odbierz_transze_bprosby


  def  odebrania_bp_ukryj
    prośby_toggle( :odebrania_bp_pokaz, nil )
    render_prośby
  end

  def odebrania_bp_pokaz
    prośby_toggle( :odebrania_bp_pokaz, true )
    render_prośby
  end


  def zmien_strony_akapitow
    ##    raise "obsolete method called: ##{annotation_controller.capitalize}Controller.zmien_strony_akapitow"
    # mamy na nią filter check_zarzadca i tylko po to robimy osobną akcję
    raise "zmień_strony_akapitów: no akat given???"    unless params[ :akat ] 
    redirect_to :action => :ustal_akapit, 
    :anotator => params[ :id ],
    :akat => params[ :akat ]
  end

  def sensowanie_anulowane
    t187 = Token.find( params[:id] )
    odswiez_bitoken( t187.id, :tylko_sens )
  end



  private

  def render_skomentowane
    render :update do |page| 
      page.replace_html( 
                        'akapity_skomentowane', 
                        :partial => 'akapity_skomentowane'
                      )
    end # of #render
  end # of #render_skomentowane


  def render_komentarze
    # (w widoku anotuj)
    akapit_transzy
    render :update do |page| 
      page.replace_html( 
                        'komentarze', 
                        :partial => 'komentarze', :object => [ @akapit_transzy, :anotacja ]
                      )
    end # of #render
  end # of #render_komentarze



  
  def zdeweryfikuj( poziom, tokids )
    # metoda, która usunie id tokenu z~hasza weryfikacji, by się już nie wyświetlało na żółto.
    logger.info "@@@@ weryfikacja przed: #{session[:weryfikacja].inspect}"
    if  (w = session[:weryfikacja] ) and  w[ poziom ]
      w[poziom] -= ( [ tokids ].flatten )
    end
    [ Token.find( tokids ) ].flatten.each{ |tok|
      tok.superancja ||= Array.new
      ##      logger.info "@@@ tok.superancja == #{tok.superancja.inspect}"
      tok.superancja |= [ poziom ]
      tok.save!
      tok.zambiguuj if poziom == :morphosyntactic
    }

    if poziom == :segmentation
      akapit_transzy.akapit.token_rejected.each{ |tok|
        tok.chosen = true
        tok.save!        
      }
    end

    unless akapit_transzy.ma_status?( poziom, :==, :osądzany ) and
        @akat_bliźniak.ma_status?( poziom, :==, :osądzany )
      # próba posłania #!= dawała wyjątek „undefined method ‘!=’ for 0:Fixnum”.
      akapit_transzy.set_status( poziom, :osądzany )
      ##      @akat_bliźniak.set_status( poziom, :osądzany, :tylko_ten )
    end

    logger.info "@@@@ weryfikacja po: #{session[:weryfikacja].inspect}"
  end # of #zdeweryfikuj


  def odswiez_bitoken( *params )
    # różni się od #odswiez_token tym, że odświeża element po obu stronach.
    tokids = params.delete_at(0)
    logger.info "@@@@@ tokids w odśwież_bitoken: #{[tokids].flatten.join(', ')}"
    tokens = Token.find( :all,
                         :conditions => { :token_id => [tokids].flatten,
                           :chosen => true } # drugi warunek dodany 2009/8/23 w~ramach tropienia  \#246.
                         ) # musi umieć obsłużyć tablicę idów, ze względu na #{segmentacja_ujednoznacznij}.
    set_uzid
    akat_hash
    render :update do |page| 
      if not ( params & [ :tylko_sens, :segmentation, :sentences ] )[ 0 ]
        if params.include?( :tworz_tag )
          tokpartial = 'token_tworz_tag'
        else 
          tokpartial = 'token_disamb'
          session[:tworz_tag] = nil if session[:tworz_tag]
        end
        tokens.each{ |tok| 
          page.replace_html "disa-token_#{@akapit_transzy.id}_#{tok.id}", 
          :partial => tokpartial, :object => [tok, @akapit_transzy, true] 

          page.replace_html "disa-token_#{@akat_bliźniak.id}_#{tok.id}", 
          :partial => tokpartial, :object => [tok, @akat_bliźniak, true] # nyhet
        }
        
      elsif (params & [ :segmentation, :sentences ])[ 0 ]
        tokens.each{ |tok|
          page.replace "outer_seg-token_#{@akapit_transzy.id}_#{tok.id}", 
          :partial => 'token_td', :object => [tok, @akapit_transzy, true] 

          page.replace "outer_seg-token_#{@akat_bliźniak.id}_#{tok.id}", 
          :partial => 'token_td', :object => [tok, @akat_bliźniak, true]  # nyhet
        }
      else
        tokens.each{ |tok|
          page.replace_html "sens-anot_#{@akapit_transzy.id}_#{tok.id}", 
          :partial => 'token_sens', :object => [tok, @akapit_transzy, true] 

          page.replace_html "sens-anot_#{@akat_bliźniak.id}_#{tok.id}", 
          :partial => 'token_sens', :object => [tok, @akat_bliźniak, true] 
        }
      end

      if params.include?( :sentences )
      page.replace_html( 
                        'sentenśnik', 
                        :partial => 'sentenśnik', :object => @akapit_transzy
                        # z jakiegoś powodu nie działało, kiedy wpisywałem tu akapit_transzy
                        )
      end
      
      page.replace_html( 
                        'status_info', 
                        :partial => 'status_info'
                        # z jakiegoś powodu nie działało, kiedy wpisywałem tu akapit_transzy
                        )
      page.replace_html( 
                        'zatwod_buttons', 
                        :partial => 'anotuj_zatwod_nk'
                        # z jakiegoś powodu nie działało, kiedy wpisywałem tu akapit_transzy
                        )
      
      page.replace( 'blizniaczy_status', :partial => 'blizniaczy_status' )
    end
  end# of #{odswiez_bitoken}.

  # #refresh_prośby zdefiniowane w~\file{anotacja_controller.rb}


  def ustaw_tylko_nowe_komentarze_ogladactwo( value )
    u = Uzytkownik.find( session[ :uzid ] )
    u.tylko_nowe_komentarze_ogladactwo = value
    u.save!
    session[ :tylko_nowe_komentarze_ogladactwo ] = u.tylko_nowe_komentarze_ogladactwo?
  end


  def ustaw_tylko_nowe_komentarze_anotacja( value )
    u = Uzytkownik.find( session[ :uzid ] )
    u.tylko_nowe_komentarze_anotacja = value
    u.save!
    session[ :tylko_nowe_komentarze_anotacja ] = u.tylko_nowe_komentarze_anotacja?
  end



end # of class
