 #
 # This file is part of the Anotatornia suite.
 # 
 # Copyright © 2007, 2008, 2009, 2010 by Instytut Podstaw Informatyki
 # Polskiej Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 # Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 # 
 # This file may be distributed and/or modified under the terms of the
 # GNU General Public License version 3 as published by the Free Software
 # Foundation and appearing in the file COPYING included in the packaging
 # of this file.  (See http://www.gnu.org/licenses/translations.html for
 # unofficial translations.)
 # 
 # A commercial license is available from IPI PAN (contact
 # Michal.Ciesiolka.waw.pl or ipi.waw.pl for more
 # information).  Licensees holding a valid commercial license from IPI
 # PAN may use this file in accordance with that license.
 # 
 # This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 # THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 # PURPOSE.
 #

# Methods added to this helper will be available to all templates in the application.
# włączam go także do kontrolera AnotacjaController.

module ApplicationHelper

  def ajax_request(argum)
    "new Ajax.Request('#{argum}', 
{asynchronous:true, evalScripts:true, 
parameters:Form.serialize(this.form)}); return false;"
  end
  
  def ajax_updater(argum1, argum2)
    "new Ajax.Updater('#{argum1}', '#{argum2}',
	 {asynchronous:true, evalScripts:true,
	 parameters:Form.serialize(this.form)}); return false;"
  end

  def r_gosc?
    r_rola?( :gosc )
  end


  def r_anotator?
    r_rola?( :anotator )
  end
  

  def r_zarzadca?
    r_rola?( :zarzadca )
  end

  def r_wszewid?
    r_rola?( :zarzadca, :audytor )
  end


  def r_admin?
    r_rola?( :admin )
  end

  
  def r_rola?( *role )
    ##    logger.info(" uzid: #{session[:uzid]}")
    Rola.ktoras_z_rol?( session[ :uzid ], *role )
  end

  def uz_login( uzid )
    Uzytkownik.find( uzid ).login  if uzid
  end

  def params_to_arri( key )
    # konwersja parametru na tablicę integerów
    params[key].to_s.split('/').collect{|x| x.to_i }
  end

  def annotation_controller
    if  r_zarzadca? : 'superanotacja'
    else 'anotacja'
    end
  end

  def log_time( log_text='' )
    logger.info "@@@@ #{log_text}: " + Time.now.to_s( :db )
  end

end# of #{module}.

### Local Variables: 
### mode: ruby
### End:
