# == Schema Information
# Schema version: 51
#
# Table name: cz_m
#
#  cz_m_id    :integer         primary key
#  cz_m_ozn   :text            
#  created_at :timestamp       
#  updated_at :timestamp       
#

 #
 # This file is part of the Anotatornia suite.
 # 
 # Copyright © 2007, 2008, 2009, 2010 by Instytut Podstaw Informatyki
 # Polskiej Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 # Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 # 
 # This file may be distributed and/or modified under the terms of the
 # GNU General Public License version 3 as published by the Free Software
 # Foundation and appearing in the file COPYING included in the packaging
 # of this file.  (See http://www.gnu.org/licenses/translations.html for
 # unofficial translations.)
 # 
 # A commercial license is available from IPI PAN (contact
 # Michal.Ciesiolka.waw.pl or ipi.waw.pl for more
 # information).  Licensees holding a valid commercial license from IPI
 # PAN may use this file in accordance with that license.
 # 
 # This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 # THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 # PURPOSE.
 #

class CzM < ActiveRecord::Base
  has_many :klasa_gram
  has_many :sensy
  has_many :cz_m_leksem

  has_many :fraza_semhead,
  :class_name => "FrazaTyp" ,
  :foreign_key => "cz_m_semhead" 

  has_many :fraza_synhead,
  :class_name => "FrazaTyp" ,
  :foreign_key => "cz_m_synhead"

  # Zapewniam stałe, bo może klient zażyczy sobie polskich nazw w bazie.
  # To oczywiście są oznaczenia części mowy stosowane w tabeli.
  # Prawdopodobnie wystarczy NOUN, bo klient życzy sobie anotacji semantycznej
  # tylko dla rzeczowników.
  NOUN='noun'
  VERB='verb'

  @@aliases = {
    :adj => "adj|adja|adjp|adjc",
    :noun => "subst|depr",
    :verb => "pact|ppas|winien|praet|bedzie|fin|impt|aglt|ger|imps|inf|pant|pcon"
  }

  def self.aliases
    @@aliases
  end

  def self.zainicjuj( force=nil )
    if  ( force or not self.find( :first)) and  (not CzMLeksem.find( :first ))
      # jeszcze sensy, ale one się wypełniają i~przypisują przy sensowlewie
      self.connection.execute "update klasa_gram set cz_m_id=null"
      self.connection.execute "update leksem set cz_m_id=null"
      self.delete_all
      raise "aborcja starej zawartości tabeli cz_m nie powiodła się" if self.find( :first )
      @@aliases.each{ |k128, v128|
        czmid = self.create!( :cz_m_ozn => k128.to_s ).id
        v128.split( '|' ).each { |kgo|
          kg = KlasaGram.find_by_klasa_gram_ozn( kgo )
          kg.cz_m_id = czmid
          kg.save!
        }# of each kg
      }# of each #@@aliases pair
      self.przypisz_leksemom
      true
      ## elsif not nie_chodzi_o_czmleksem
      ##  raise "CzM.zainicjuj: próba wywołania miesiączki po 12. tygodniu (wobec niepustej tabeli cz_m_leksem)!"
    else
      false
    end
  end # of #{self.zainicjuj}

  def self.przypisz_leksemom
    self.connection.execute " update leksem set cz_m_id=" +
      "(select cz_m_id from klasa_gram k where k.klasa_gram_id=leksem.klasa_gram_id)," +
      " updated_at=current_timestamp, cz_m_przypisana='t'" +
      " where cz_m_przypisana='f' "
  end

  
  zainicjuj

  
  
end

