# == Schema Information
# Schema version: 51
#
# Table name: interpretacja_anot
#
#  interpretacja_anot_id :integer         primary key
#  akapit_transzy_id     :integer         not null
#  uzytkownik_id         :integer         not null
#  token_id              :integer         not null
#  interpretacja_id      :integer         not null
#  created_at            :timestamp       
#  updated_at            :timestamp       
#

 #
 # This file is part of the Anotatornia suite.
 # 
 # Copyright © 2007, 2008, 2009, 2010 by Instytut Podstaw Informatyki
 # Polskiej Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 # Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 # 
 # This file may be distributed and/or modified under the terms of the
 # GNU General Public License version 3 as published by the Free Software
 # Foundation and appearing in the file COPYING included in the packaging
 # of this file.  (See http://www.gnu.org/licenses/translations.html for
 # unofficial translations.)
 # 
 # A commercial license is available from IPI PAN (contact
 # Michal.Ciesiolka.waw.pl or ipi.waw.pl for more
 # information).  Licensees holding a valid commercial license from IPI
 # PAN may use this file in accordance with that license.
 # 
 # This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 # THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 # PURPOSE.
 #

class InterpretacjaAnot < ActiveRecord::Base
  belongs_to :interpretacja
  belongs_to :uzytkownik
  belongs_to :token
  belongs_to :akapit_transzy


# usuwanie tagów dodanych a sierocych znajduje się w klasie Token.

  def bliźniacza
    @bli_hasz = {
      :akapit_transzy_id => self.akapit_transzy.blizniaczy_id,
      :token_id => self.token_id
    }
    self.class.find(
                    :first,
                    :conditions => @bli_hasz )
  end # of #bliźniacza
  

  def skopiuj_na_bliźniaczą
    bli = self.bliźniacza # ta met. tworzy #@bli_hasz
    bli ||= self.class.new( @bli_hasz )  
    bli.interpretacja_id = self.interpretacja_id
    bli.uzytkownik_id= self.uzytkownik_id
    bli.save!
  end # of #{skopiuj_na_bliźniaczą}


end


### Local Variables: 
### mode: ruby
### End:
