# == Schema Information
# Schema version: 51
#
# Table name: prosby_anotatorek
#
#  prosby_anotatorek_id :integer         primary key
#  dotyczy_id           :integer         not null
#  dotyczy_type         :text            not null
#  uzytkownik_id        :integer         not null
#  opis                 :text            
#  created_at           :timestamp       
#  updated_at           :timestamp       
#  rozpatrzona          :boolean         
#  spelniona            :boolean         
#

 #
 # This file is part of the Anotatornia suite.
 # 
 # Copyright © 2007, 2008, 2009, 2010 by Instytut Podstaw Informatyki
 # Polskiej Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 # Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 # 
 # This file may be distributed and/or modified under the terms of the
 # GNU General Public License version 3 as published by the Free Software
 # Foundation and appearing in the file COPYING included in the packaging
 # of this file.  (See http://www.gnu.org/licenses/translations.html for
 # unofficial translations.)
 # 
 # A commercial license is available from IPI PAN (contact
 # Michal.Ciesiolka.waw.pl or ipi.waw.pl for more
 # information).  Licensees holding a valid commercial license from IPI
 # PAN may use this file in accordance with that license.
 # 
 # This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 # THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 # PURPOSE.
 #

class ProsbyAnotatorek < ActiveRecord::Base
  belongs_to :uzytkownik
  belongs_to :dotyczy, :polymorphic => true

  serialize  :ruby_data

  def self.nowe( rola_id )
    conds = {:rozpatrzona => false}
    unless Rola.zarzadca?( rola_id )
      conds[ :dotyczy_type ] = "NowaSegmentacja"
    end

    self.find(:all,
              :include => :uzytkownik,
              :order => "#{self.table_name}.created_at",
              :conditions => conds)
  end # of #self.nowe


  K_segmentacyjna = "Czy rzeczywiście chcesz dodać nowy wariant segmentacyjny?\n 
Spowoduje to w szczególności cofnięcie odp. akapitu/ów na najniższy poziom anotacji."

  K_transzowa = "Czy rzeczywiście chcesz odebrać transzę?"
  
  def rodzaj
    if self.dotyczy_type == "Transza"
      "odebranie transzy"
    else
      "segmentacja"
    end
  end # of #rodzaj

  def self.k_segmentacyjna
    K_segmentacyjna
  end

  def konfirmacja
    if self.dotyczy_type == "Transza" 
      K_transzowa
    else
      K_segmentacyjna
    end
  end # of #konfirmacja

  def treść_acc # do „odrzuciłeś/spełniłeś prośbę o …”
    dot = self.dotyczy
    if dot.is_a?( Transza )
      "odebranie transzy #{dot.id}"
    elsif dot.is_a?( NowaSegmentacja )
      seg_is = dot.seg_is
      seg_should_be = dot.seg_should_be
      zespa, zespójnik = if dot.nps? : [ "(z brakiem spacji)", "|" ]
                         else [ "(ze spacjami)", " " ]
                         end
      zespa = nil      if seg_should_be.size == 1

      "nowy wariant segmentacyjny »<b>#{seg_is.join(' ')}</b>« &#8614; »<b>#{seg_should_be.join( zespójnik )}</b>« #{zespa} w akapicie/tach <b>#{dot.ids.join(', ')}</b>" + 
        if akat = dot.akapit_transzy_id : " (dla akatru #{akat} w&nbsp;transzy <b>#{dot.transza_id}</b>)" else '' end
    end
  end # of #treść_acc
  
 
  def treść_z_opisem
    treść_acc.gsub( /^zmianę segmentacji/, 'zmiana segmentacji') +
      if o = self.opis : " <br/> #{o}" else '' end
  end # of #treść_z_opisem

  def odfajkuj( wynik = true )
    self.class.transaction do
      self.rozpatrzona = true
      self.spelniona = wynik
      self.save! 
    end # of transaction
  end # of #odfajkuj


  def commit( rola_id )
    if self.dotyczy.is_a?( Transza ) and Rola.zarzadca?( rola_id )
      
      self.class.transaction do
        self.dotyczy.uzytkownik_id = nil
        self.dotyczy.save!
        self.odfajkuj
      end # of transaction
      "Odebrałaś/eś #{dotyczy.uzytkownik.login} transzę #{dotyczy.opis}."
      
    elsif self.dotyczy.is_a?( NowaSegmentacja ) and # wariant segmentacyjny
        Rola.wszewid?( rola_id )
      self.class.transaction do
        self.dotyczy.commit
        self.odfajkuj
      end # of transaction
      "Dodałeś #{self.treść_acc}."
    else
      "Nie masz prawa spełnić tej prośby."
    end # of rodzaje próśb
  end # of #commit


  def odrzuć( rola_id )
    if Rola.zarzadca?( rola_id ) or  ( 
                                      self.dotyczy.is_a?( NowaSegmentacja ) and # wariant segmentacyjny
                                      Rola.wszewid?( rola_id ) )
    
      self.odfajkuj( false )
      "Odrzuciłeś prośbę #{self.uzytkownik.login} o  #{self.treść_acc}."
    else
      "Nie masz prawa spełnić tej prośby."
    end #     
  end # of #odrzuć


end # of class
  
