# == Schema Information
# Schema version: 51
#
# Table name: sensy
#
#  sensy_id       :integer         primary key
#  cz_m_id        :integer         not null
#  cz_m_leksem_id :integer         not null
#  xmlid          :text            
#  n              :integer         
#  short_def      :text            
#  long_def_xml   :text            
#  long_def_html  :text            
#  created_at     :timestamp       
#  updated_at     :timestamp       
#

 #
 # This file is part of the Anotatornia suite.
 # 
 # Copyright © 2007, 2008, 2009, 2010 by Instytut Podstaw Informatyki
 # Polskiej Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 # Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 # 
 # This file may be distributed and/or modified under the terms of the
 # GNU General Public License version 3 as published by the Free Software
 # Foundation and appearing in the file COPYING included in the packaging
 # of this file.  (See http://www.gnu.org/licenses/translations.html for
 # unofficial translations.)
 # 
 # A commercial license is available from IPI PAN (contact
 # Michal.Ciesiolka.waw.pl or ipi.waw.pl for more
 # information).  Licensees holding a valid commercial license from IPI
 # PAN may use this file in accordance with that license.
 # 
 # This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 # THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 # PURPOSE.
 #

class Sensy < ActiveRecord::Base
  belongs_to :cz_m
  belongs_to :cz_m_leksem
  has_many :interpretacja
  has_many :sens_anot


  @short_description = nil
  @long_description = nil
  
  def short_description
    if ( num199 = self.n ) == 666666
      lemat199 = "inne znaczenie"
      num199 = ''
    else
      lemat199 = self.cz_m_leksem.lemat
      num199 = "#{num199}:"
    end
    @short_description ||= 
      "<span class=\"sc\">#{lemat199}</span> #{num199}&#8194;#{self.short_def}" # to jest półfiret. Ćwierćfiret: \verb|&#8197;|
  end


  @@rends = Hash.new { |h193, key193| 
    raise "Sensy.@@rends:  unrecognised key #{key193}" }
  @@rends[ 'bold' ] = 'b' 


  def short_def_html
    # w tej wersji słownika (2009/8/20) niepotrzebne: w shortdefach nie ma żadnych znaczników xml.
    @rends_short = []
    rend_no = 0
    ssd193 = self.short_def.gsub( /<hi rend="(.*?)">/ # dopasowanie niezachłanne (minimalne)
                                  ) { |match193| 
      r193 = (  @rends_short[rend_no] = @@rends[ $1 ] )
      rend_no += 1
      "<#{r193}>" }
    rend_no = -1
    ssd193.gsub( /<\/hi>/ ) { |match193|
      rend_no += 1
      "</#{@rends[rend_no]}>"
    }
  end


  def long_description
    @long_description ||= self.long_def_html
    # prawdopodobnie będziemy podmieniać znaczniki \ac{XML}\dy owe \file{sense_inventory} na \ac{HTML}\dy owe.
  end

  def long2html
# gromadkę podsensów ujmujemy w listę numerowaną
    sld193 = "<ol>\n" + self.long_def_xml + "\n</ol>"
# podsens w element listy
    sld193 = sld193.
      gsub(/<sense n="(.*)">/) { |match192| "<li value=\"#{$1}\">"}.
      gsub( /<\/sense>/, "" )
      
    @rends_long = []
    rend_no = 0
    sld193 = sld193.gsub( /<hi rend="(.*?)">/  # dopasowanie niezachłanne (minimalne)
                          ) { |match193| 
      r193 = (  @rends_long[rend_no] = @@rends[ $1 ] )
      rend_no += 1
      "<#{r193}>" }
    rend_no = -1
    sld193 = sld193.gsub( /<\/hi>/ ) { |match193|
      rend_no += 1
      "</#{@rends_long[rend_no]}>"
    }

    sld193 = sld193.gsub( /<\/*def>/, "" ). # elementy def zwykłą czcionką
      gsub( /<\/*cit( type="dicteg")*>/, "" ). # cit-y ignorujemy, a~dokładniej: obsługujemy poniżej
      gsub(/<quote>/, " &#8194;•<i>&nbsp;").
      gsub(/<\/quote>/, "</i> ").
      gsub(/\b([awuiozAWUIOZ])( +)/, '\1&nbsp;') # wiszące litery

    self.long_def_html = sld193
    self.save!
  end # of #long2html


  def self.long2html( *query_params )
    sf193 = self.find( *query_params )
    if sf193
      if sf193.kind_of?( Sensy )
        sf193.long2html 
      else
        sf193.each { |sens193|
          @@currid = sens193.id
          sens193.long2html }
      end
      return true
    else return false
    end
  end # of #{self.long2html}.

  # treść opisów do „inne”
  INNE_short = ''
  INNE_long = "Znaczenie inne od podanych powyżej.  Niniejsze " +
    "„znaczenie” powinno być wybierane tylko w wyjątkowych i dobrze " +
    "uzasadnionych wypadkach."
  INNE_long_html = "<p>" + INNE_long + "</p>"

  def self.dopisz_inne
    # każdy cz_m_leksem ma mieć sens <inne>
    CzMLeksem.dopisz_inne    
  end


  
end
