# == Schema Information
# Schema version: 51
#
# Table name: sg_choice
#
#  sg_choice_id :integer         primary key
#  akapit_id    :integer         not null
#  dodany       :boolean         
#  xmlid        :text            
#  created_at   :timestamp       
#  updated_at   :timestamp       
#

 #
 # This file is part of the Anotatornia suite.
 # 
 # Copyright © 2007, 2008, 2009, 2010 by Instytut Podstaw Informatyki
 # Polskiej Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 # Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 # 
 # This file may be distributed and/or modified under the terms of the
 # GNU General Public License version 3 as published by the Free Software
 # Foundation and appearing in the file COPYING included in the packaging
 # of this file.  (See http://www.gnu.org/licenses/translations.html for
 # unofficial translations.)
 # 
 # A commercial license is available from IPI PAN (contact
 # Michal.Ciesiolka.waw.pl or ipi.waw.pl for more
 # information).  Licensees holding a valid commercial license from IPI
 # PAN may use this file in accordance with that license.
 # 
 # This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 # THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 # PURPOSE.
 #

class SgChoice < ActiveRecord::Base
  belongs_to :akapit
  has_many :sg_variant, :dependent => :destroy # klauzula destrukcji dodana 2009/7/4, dla zniszczenia niefortunnego „niedostrzeganiem” z~akapitu 19 (migracja 010)

  def token # to, że nie jest to #{has_many}, ma poważną przyczynę.
    Token.find( :all, :conditions => { :sg_choice_id => self.id },
                :order => :kolejnosc )
  end# of #token


  def last_chosen_token
    unless defined?( @last_chosen_token ) and @last_chosen_token
      @last_chosen_token = Token.find( :first, 
                                       :conditions => { :sg_choice_id => self.id, :chosen => true },
                                       :order => "kolejnosc desc" )
    end
    @last_chosen_token
  end

  def segmentation_xmlid
    # używana do oznaczenia  zdania w wypluwce. 
    # Zdanie chcemy oznaczyć ostatnim tokenem.
    if t213 = last_chosen_token
      t213.segmentation_xmlid
    end
  end


  def morphosyntactic_xmlid
    # używana do oznaczenia  zdania w wypluwce. 
    # Zdanie chcemy oznaczyć ostatnim tokenem.
    if t213 = last_chosen_token
      t213.morphosyntactic_xmlid
    end
  end
  

  @tokids = nil

  def tokids
    unless @tokids
      @tokids = self.token.collect{ |t128| t128.id }
    end
    @tokids
  end


end
