 #
 # This file is part of the Anotatornia suite.
 # 
 # Copyright © 2007, 2008, 2009, 2010 by Instytut Podstaw Informatyki
 # Polskiej Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 # Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 # 
 # This file may be distributed and/or modified under the terms of the
 # GNU General Public License version 3 as published by the Free Software
 # Foundation and appearing in the file COPYING included in the packaging
 # of this file.  (See http://www.gnu.org/licenses/translations.html for
 # unofficial translations.)
 # 
 # A commercial license is available from IPI PAN (contact
 # Michal.Ciesiolka.waw.pl or ipi.waw.pl for more
 # information).  Licensees holding a valid commercial license from IPI
 # PAN may use this file in accordance with that license.
 # 
 # This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 # THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 # PURPOSE.
 #

# 2008/09/11 file got from ap.rb to handle the nk (Narodowy Korpus) environment.

$mydirname= File.dirname(__FILE__) unless $mydirname

require $mydirname +'/unatrora'

unless $port
  __FILE__ =~ /.*\/nk(\d*)\.rb$/
  $port = $1.to_i
end

# Settings specified here will take precedence over those in config/environment.rb

class DlaEli
  def self.x
    false
  end

  def self.nk
    true
  end

end


class AnoVersion
# klasa niosąca informację, czy dana instancja Anotatorni
# ma działać wg specyfikacji Eli Hajnicz (true) 
# czy Adama Przepiórkowskiego (false) ---
# zaczęło się od tego, że AP nie potrzebuje oznaczania sensów i nie chce typu "się".
  
  @@port = $port
  
  @@port_uzy = if $port == 8004 : 8003 else $port end
  ##  @@port_uzy = 8003

  @@text =  case $port
            when 8003
              "NKJP (<span class=\"sc\">produkcyjna (z WSD)</span>, #{$port})"
            when 8004
              "<span style=\"background-color: red; color: black\" class=\"sc\">ćwiczebna (#{$port})</span>"
            when 8005
              "NKJP <span style=\"background-color: red; color: black\" class=\"sc\">WSD w budowie (#{$port})</span>"
            when 8006
              raise "8006 nie działa"
              "NKJP <span class=\"sc\">trzeci</span> test (#{$port})"
            when 8007
              # kopia 8007 służy wyłącznie do generowania wypluwki (baza użytkowników też jest kopiowana)
              "<span style=\"background-color: red; color: black\" class=\"sc\">wypluwkowa (#{$port})</span>"
            end
  
  @@export_text = @@text.gsub( /<\/*span[^>]*>/, '')
  
  if @@port != 8009 # 8005
    @@rozmiar_transzy = 10
  else
    @@rozmiar_transzy = 4
  end

  def self.port
    @@port
  end

  def self.port_uzy
    @@port_uzy
  end

  def self.text
    @@text
  end

  def self.export_text
    @@export_text
  end


  def self.rozmiar_transzy
    @@rozmiar_transzy
  end

end # of class #{AnoVersion}


unless UNatrora.x
  # The production environment is meant for finished, "live" apps.
  # Code is not reloaded between requests
  config.cache_classes =     true
  
  # Use a different logger for distributed setups
  # config.logger = SyslogLogger.new
  
  # Full error reports are disabled and caching is turned on
  config.action_controller.consider_all_requests_local = false
  config.action_controller.perform_caching             =  true
  
  # Enable serving of images, stylesheets, and javascripts from an asset server
  # config.action_controller.asset_host                  = "http://assets.example.com"
  
  # Disable delivery errors, bad email addresses will be ignored
  # config.action_mailer.raise_delivery_errors = false
  
else
  
  # In the development environment your application's code is reloaded on
  # every request.  This slows down response time but is perfect for development
  # since you don't have to restart the webserver when you make code changes.
  if UNatrora.x
    config.cache_classes = true
  else  config.cache_classes = true
  end
  # Log error messages when you accidentally call methods on nil.
  config.whiny_nils = true
  
  # Enable the breakpoint server that script/breakpointer connects to
  config.breakpoint_server = true
  
  # Show full error reports and disable caching
  config.action_controller.consider_all_requests_local = true
  config.action_controller.perform_caching             = false
  config.action_view.cache_template_extensions         = false
  config.action_view.debug_rjs                         = true
  
  # Don't care if the mailer can't send
  config.action_mailer.raise_delivery_errors = false

end


ActionController::Base.session_options[:session_key] = "anotatornia_#{AnoVersion.port}"
ActionController::Base.session_options[ :secret ] = 'jA0EAwMCX3TTkt5L62Fgye14otCauhuAsBlsJlVBTJ6Y+1D/Uln5ZkT3hZt3aVV2mQ1zFhRgfk1c2jJNjNwCILbjIPrDNvfuJLUDJlfBJ1Kq1yMGKBHfQzkETDvJhMbKhfFmgJtIGhdEspUSj6NdIGBC1J+YuG3cOUw/8T6JpT6Tw61OT7XexKXVZxmw/i5f3mhQQxezCC0wWP2Qp/KXCprAn3GbJC9OL9k0sYioKtlVuwiJVN7HaO7Nx+gUg/u5RsGZW/42oq2U7BXPmmjLPtfD9Kqd7VHpyWVRUe57ffYYBI3BEpQZfTCzqOJEmQxK' + "#{AnoVersion.port}"



