CREATE TABLE corpus_path(
-- Attributes --
corpus_path_id integer primary key autoincrement,
path text);
CREATE TABLE cz_m(
-- Attributes --
cz_m_id integer primary key,
cz_m_nazwa text);
CREATE TABLE czasownik_auto(
-- Attributes --
czasownik_auto_id integer primary key,
bezokolicznik text,
ile_zdan_cz integer);
CREATE TABLE fraza_anot(
-- Attributes --
fraza_anot_id integer primary key,
zdanie_id integer,
uzytkownik_id integer,
nr_wyr_pocz integer,
nr_wyr_kon integer,
token_id_synhead integer,
token_id_semhead integer,
fraza_typ_id integer,
vp_typ integer,
sie_typ integer);
CREATE TABLE fraza_typ(
-- Attributes --
fraza_typ_id integer primary key,
typ_opis text,
typ_symbol text,
cz_m_synhead integer,
cz_m_semhead integer);
CREATE TABLE interpretacja(
-- Attributes --
interpretacja_id integer primary key,
token_id integer,
disamb boolean,
numer_lex_token integer,
reszta_tagu text,
leksem_id integer);
CREATE TABLE interpretacja_anot(
-- Attributes --
opis_morf_anot_id integer primary key,
uzytkownik_id integer,
interpretacja_id integer);
CREATE TABLE klasa_gram(
-- Attributes --
klasa_gram_id integer primary key autoincrement,
cz_m_id integer,
klasa_gram_nazwa text,
klasa_gram_ozn text);
CREATE TABLE komentarz(
-- Attributes --
komentarz_id integer primary key,
zdanie_id integer,
uzytkownik_id integer,
nr_kom_zd integer,
tresc text,
temat integer);
CREATE TABLE leksem(
-- Attributes --
leksem_id integer primary key autoincrement,
lemat text,
klasa_gram_id integer);
CREATE TABLE plik_morph(
-- Attributes --
plik_morph_id integer primary key,
abs_path text,
ile_zdan integer);
CREATE TABLE rola (
         opis text,
         rola_id integer primary key, opis_kr string);
CREATE TABLE schema_info (version integer);
CREATE TABLE sens(
-- Attributes --
sens_id integer primary key,
sens_opis text,
sens_ozn text,
cz_m_id integer);
CREATE TABLE sens_anot(
-- Attributes --
sens_anot_id integer primary key,
uzytkownik_id integer,
token_id integer,
sensy_leksemu_id integer);
CREATE TABLE sensy_leksemu(
-- Attributes --
sensy_leksemu_id integer primary key,
sens_id integer,
leksem_id integer,
nowy boolean,
liczba_uzyc integer);
CREATE TABLE session ("id" INTEGER PRIMARY KEY NOT NULL, "session_id" varchar(255) DEFAULT NULL, "data" text DEFAULT NULL, "updated_at" datetime DEFAULT NULL);
CREATE TABLE status_zd_auto(
-- Attributes --
status_id integer,
zdanie_id integer,
uzytkownik_id integer,
moment integer);
CREATE TABLE token(
-- Attributes --
token_id integer primary key,
zdanie_id integer,
nr_wyrazu_zd integer,
orth text,
tok_id_morph integer,
czy_interp boolean,
ns_poprzedza boolean);
CREATE TABLE transza_auto(
-- Attributes --
transza_auto_id integer primary key,
uzytkownik_id integer,
czasownik_auto_id integer,
czy_zakonczona integer,
prosba_odebrania integer,
przyczyna_prosby text,
czy_aktualna integer,
ile_zdan_tr integer);
CREATE TABLE uzytkownik (
      uzytkownik_id integer primary key,
      rola_id integer not null,
      login text not null,
      hasz_haslo text not null,
      sol text not null,
      imie text,
      nazwisko text,
      ile_razy_zaanotowal integer,
      ile_zd_zweryfikowanych integer);
CREATE TABLE zdania_transzy(
-- Attributes --
zdanie_id integer,
transza_auto_id integer);
CREATE TABLE zdanie(
-- Attributes --
zdanie_id integer primary key,
czy_zweryfikowane integer,
ile_weryfikacji_auto integer default null,
czy_osadzone integer,
czy_arbitralnie integer,
ktora_weryf_aut_ok integer,
got_do_weryf_recznej integer,
got_do_osadzenia integer,
nr_morph_chunk_p integer,
nr_morph_chunk_s integer,
plik_morph_id integer,
corpus_path_id integer,
czasownik_auto_id integer,
nr_zdania_czasow integer,
data_zatwierdzenia datetime);
CREATE INDEX corpus_path_path
on 
corpus_path (path);
CREATE INDEX "index_session_on_session_id" ON session ("session_id");
CREATE INDEX "index_session_on_updated_at" ON session ("updated_at");
CREATE INDEX interpretacja_numer_lex_token
on 
interpretacja (numer_lex_token);
CREATE INDEX interpretacja_token_id
on 
interpretacja (token_id);
CREATE INDEX klasa_gram_klasa_gram_ozn
on 
klasa_gram (klasa_gram_ozn);
CREATE INDEX leksem_lemat_klasa_gram_id
on 
leksem (lemat, klasa_gram_id);
CREATE INDEX token_nr_wyrazu_zd
on 
token (nr_wyrazu_zd);
CREATE INDEX token_zdanie_id
on 
token (zdanie_id);
CREATE INDEX zdanie_corpus_path_id
on 
zdanie (corpus_path_id);
INSERT INTO schema_info (version) VALUES (4)