 #
 # This file is part of the Anotatornia suite.
 # 
 # Copyright © 2007, 2008, 2009, 2010 by Instytut Podstaw Informatyki
 # Polskiej Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 # Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 # 
 # This file may be distributed and/or modified under the terms of the
 # GNU General Public License version 3 as published by the Free Software
 # Foundation and appearing in the file COPYING included in the packaging
 # of this file.  (See http://www.gnu.org/licenses/translations.html for
 # unofficial translations.)
 # 
 # A commercial license is available from IPI PAN (contact
 # Michal.Ciesiolka.waw.pl or ipi.waw.pl for more
 # information).  Licensees holding a valid commercial license from IPI
 # PAN may use this file in accordance with that license.
 # 
 # This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 # THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 # PURPOSE.
 #

class AddUpdated < ActiveRecord::Migration
  def self.up
    bloobraZ = false

    adup = Proc.new { |model|
      unless model.column_names.include?( "updated_at" )    
        execute "alter table #{model.table_name} add column updated_at timestamp"
        bloobraZ = true
      end
    }

    adup.call(CzM)
    adup.call(FrazaTyp)
    adup.call(MorphosyntacticRozbieznosc)
    adup.call(Leksem)
    adup.call(Komentarz)
    adup.call(KlasaGram)
    adup.call(Protokol)

    unless PunktProtokolu.column_names.include?("created_at") and
        PunktProtokolu.column_names.include?("updated_at")
      
      execute "alter table punkt_protokolu rename to pp_old;"
      execute "CREATE TABLE IF NOT EXISTS punkt_protokolu(
        punkt_protokolu_id integer primary key autoincrement,
        elt_protokol_id integer not null,
        elt_protokol_type text not null,
        protokol_id integer not null,
        akapit_transzy_id integer not null,
        uzytkownik_id integer,
	created_at timestamp default current_timestamp,
	updated_at timestamp);"
      execute "insert into punkt_protokolu(
        punkt_protokolu_id,
        elt_protokol_id, 
        elt_protokol_type,
        protokol_id,
	akapit_transzy_id,
        uzytkownik_id)
select punkt_protokolu_id,
        elt_protokol_id, 
        elt_protokol_type,
        protokol_id,
	akapit_transzy_id,
        uzytkownik_id from pp_old;"
      execute "drop table pp_old;"
      
      bloobraZ = true
    end # of #{unless PunktProtokolu…}

    adup.call(Rola)
    adup.call(SgVariant)
    adup.call(KoniecZdaniaAnot)
    adup.call(SentencesRozbieznosc)
    adup.call(Path)
    adup.call(SegmentationRozbieznosc)
    adup.call(Sensy)
    adup.call(Tagset)
    adup.call(Transza)
    adup.call(Akapit)
    adup.call(Morph)

    execute "vacuum" if bloobraZ
  end

  def self.down
  end
end
