 #
 # This file is part of the Anotatornia suite.
 # 
 # Copyright © 2007, 2008, 2009, 2010 by Instytut Podstaw Informatyki
 # Polskiej Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 # Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 # 
 # This file may be distributed and/or modified under the terms of the
 # GNU General Public License version 3 as published by the Free Software
 # Foundation and appearing in the file COPYING included in the packaging
 # of this file.  (See http://www.gnu.org/licenses/translations.html for
 # unofficial translations.)
 # 
 # A commercial license is available from IPI PAN (contact
 # Michal.Ciesiolka.waw.pl or ipi.waw.pl for more
 # information).  Licensees holding a valid commercial license from IPI
 # PAN may use this file in accordance with that license.
 # 
 # This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 # THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 # PURPOSE.
 #

class TokenAddKolejnosc < ActiveRecord::Migration

  extend MigrationHelper
  
  
  def self.up
    sth_added =  addcolumn( 'token', 'kolejnosc', 'integer' )
    
    unless Token.column_names.include?( "kolejnosc" )
      execute "alter table token rename to t0"
      
execute "
CREATE TABLE IF NOT EXISTS token(
   token_id integer primary key autoincrement,
   kolejnosc integer not null,
   akapit_id integer not null,
   xpointer text,
   segmentation_xmlid text,
   morphosyntactic_xmlid text,
   fs_morph_comment text,
   path_id integer not null,
   orth text,
   czy_interp boolean not null,
   ns_poprzedza boolean default 'f', 
   ns_nastepuje boolean,
   czy_konczy_zdanie boolean,
   czy_konczy_zdanie_updated_at timestamp,
   sg_choice_id integer null default null,
   sg_variant_id integer null default null,
   dodany boolean default 'f' not null,
   chosen boolean default 't', -- dedukowalne z sg_variant_anot
   chosen_updated_at timestamp,
   created_at timestamp default current_timestamp,
   updated_at timestamp default current_timestamp
)"

execute " insert into token(
   token_id,
   kolejnosc,
   akapit_id,
   xpointer,
   segmentation_xmlid,
   morphosyntactic_xmlid,
   fs_morph_comment,
   path_id,
   orth,
   czy_interp,
   ns_poprzedza, 
   ns_nastepuje,
   czy_konczy_zdanie,
   czy_konczy_zdanie_updated_at,
   sg_choice_id,
   sg_variant_id,
   chosen,
   chosen_updated_at,
   created_at,
   updated_at) 

select 
   token_id,
token_id * 216 as kolejnosc,
   akapit_id,
   xpointer,
   segmentation_xmlid,
   morphosyntactic_xmlid,
   fs_morph_comment,
   path_id,
   orth,
   czy_interp,
   ns_poprzedza, 
   ns_nastepuje,
   czy_konczy_zdanie,
   czy_konczy_zdanie_updated_at,
   sg_choice_id,
   sg_variant_id,
   chosen,
   chosen_updated_at,
   created_at,
   updated_at
from t0"

      execute "drop table t0"
      sth_added = true
    end

    unless Token.find_by_sql( "select * from token where kolejnosc is not null limit 1" )[0]
      execute "update token set kolejnosc = token_id*216"
    end

    addindex( 'token', 'akapit_id' )
    addindex "token", "czy_interp"
    addindex "token", 'ns_nastepuje'
    addindex  'token', 'ns_poprzedza'
    addindex 'token', ['path_id', 'morphosyntactic_xmlid']
    addindex 'token', [:path_id, :segmentation_xmlid ], :unique
    addindex  :token,  :sg_choice_id
    addindex  :token, :sg_variant_id
    
    addindex( 'token', 'kolejnosc', :unique )
    addindex( 'token', 'dodany' )
  
    execute "vacuum" if sth_added
  end  
  
  def self.down
  end
end
