 #
 # This file is part of the Anotatornia suite.
 # 
 # Copyright © 2007, 2008, 2009, 2010 by Instytut Podstaw Informatyki
 # Polskiej Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 # Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 # 
 # This file may be distributed and/or modified under the terms of the
 # GNU General Public License version 3 as published by the Free Software
 # Foundation and appearing in the file COPYING included in the packaging
 # of this file.  (See http://www.gnu.org/licenses/translations.html for
 # unofficial translations.)
 # 
 # A commercial license is available from IPI PAN (contact
 # Michal.Ciesiolka.waw.pl or ipi.waw.pl for more
 # information).  Licensees holding a valid commercial license from IPI
 # PAN may use this file in accordance with that license.
 # 
 # This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 # THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 # PURPOSE.
 #

class SpatializeNpses < ActiveRecord::Migration
  def self.up
    aks = Akapit.find_by_sql( "select * from akapit inner join path using( path_id ) where path_text like '%310-1-000001%' or path_text like   '%330-1-000003%' or path_text like  '%330-1-000004%';")
    aids= aks.collect{ |a| a.id }
    ts = Token.find( :all, :conditions => {:akapit_id => aids, :ns_poprzedza => true, :czy_interp => false} )
    ts.each{ |t| 
      if %w(a i o u w z się jedynie A I O U W Z Się Jedynie).include?( t.poprzedni.orth )
        t.ns_poprzedza = false
        t.save!
      end
    }

    Token.update_ns_nastepuje( aids.min, aids.max, :force ) if aids[0]
    

  end

  def self.down
  end
end
