 #
 # This file is part of the Anotatornia suite.
 # 
 # Copyright © 2007, 2008, 2009, 2010 by Instytut Podstaw Informatyki
 # Polskiej Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 # Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 # 
 # This file may be distributed and/or modified under the terms of the
 # GNU General Public License version 3 as published by the Free Software
 # Foundation and appearing in the file COPYING included in the packaging
 # of this file.  (See http://www.gnu.org/licenses/translations.html for
 # unofficial translations.)
 # 
 # A commercial license is available from IPI PAN (contact
 # Michal.Ciesiolka.waw.pl or ipi.waw.pl for more
 # information).  Licensees holding a valid commercial license from IPI
 # PAN may use this file in accordance with that license.
 # 
 # This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 # THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 # PURPOSE.
 #

class PoprawLexXmlidy < ActiveRecord::Migration

  extend MigrationHelper

  def self.up
    ido = Interpretacja.find( :all, :conditions => { :dodana => true } )
    ido.each { |int|
      if Interpretacja.find( :first, :conditions => 
                             [ " dodana ='f' and token_id=? and lex_xmlid = ? and leksem_id <> ? ", 
                               int.token_id, int.lex_xmlid, int.leksem_id ]
                             )

        puts int.created_at.to_s( :db )

        nry_lt, lexids_h = int.zainnij
        
        nr_lt = lexids_h[ int.leksem_id ]
        nr_lt ||= nry_lt.max + 1
      
        int.numer_lex_token = nr_lt
        int.lex_xmlid = int.lex_xmlid.gsub( /(\d*)\.(\d*)\.(\d*)/, "\\1.\\2.#{nr_lt}" )
        int.msd_xmlid = int.msd_xmlid.gsub( /(\d*)\.(\d*)\.(\d*)\.(\d*)/, "\\1.\\2.#{nr_lt}.\\4" )
        int.save!
      end
      }

  end

  def self.down
  end
end
