 #
 # This file is part of the Anotatornia suite.
 # 
 # Copyright © 2007, 2008, 2009, 2010 by Instytut Podstaw Informatyki
 # Polskiej Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 # Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 # 
 # This file may be distributed and/or modified under the terms of the
 # GNU General Public License version 3 as published by the Free Software
 # Foundation and appearing in the file COPYING included in the packaging
 # of this file.  (See http://www.gnu.org/licenses/translations.html for
 # unofficial translations.)
 # 
 # A commercial license is available from IPI PAN (contact
 # Michal.Ciesiolka.waw.pl or ipi.waw.pl for more
 # information).  Licensees holding a valid commercial license from IPI
 # PAN may use this file in accordance with that license.
 # 
 # This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 # THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 # PURPOSE.
 #


class PrzepiszBaze < ActiveRecord::Migration

  extend MigrationHelper

  def self.up
    if false
      pragmas_for_update

    przepisz_tabelę "create TABLE IF NOT EXISTS cz_m(
cz_m_id integer primary key autoincrement,
cz_m_ozn text, 
created_at timestamp,
updated_at timestamp);"

    przepisz_tabelę( "create TABLE IF NOT EXISTS sensy(
   sensy_id integer primary key autoincrement,
   cz_m_id integer not null,
   cz_m_leksem_id integer not null,
   xmlid text,
   short_def text,
   sensy_xml text,
   created_at timestamp, 
   updated_at timestamp
);",
    
                     "create index if not exists sensy_cz_m_id
on sensy( cz_m_id );",

                     "create unique index if not exists sensy_xmlid
on sensy( xmlid );")


    przepisz_tabelę( "create TABLE IF NOT EXISTS sens_anot(
   sens_anot_id integer primary key autoincrement,
   uzytkownik_id integer,
   akapit_transzy_id integer not null,
   interpretacja_id integer not null,
   sensy_id integer not null, 
   automatycznie boolean,
   created_at timestamp, 
   updated_at timestamp);",

                     "create index IF NOT EXISTS sens_anot_sensy_id
on sens_anot( sensy_id );",

                     " create index IF NOT EXISTS sens_anot_interpretacja_id
on sens_anot( interpretacja_id );" ,
                     
                     "create index IF NOT EXISTS sens_anot_interpretacja_id_akapit_transzy_id
on sens_anot( interpretacja_id, akapit_transzy_id );",

                     "create index IF NOT EXISTS sens_anot_akapit_transzy_id
on sens_anot( akapit_transzy_id );"
                     )


    przepisz_tabelę( "create TABLE IF NOT EXISTS cz_m_leksem(
cz_m_leksem_id integer primary key autoincrement,
lemat text not null,
xmlid text not null,
cz_m_id integer not null,
created_at timestamp,
updated_at timestamp);",
    
                     "create unique index IF NOT EXISTS cz_m_leksem_lemat_cz_m_id
on cz_m_leksem (lemat, cz_m_id);",

                     "create unique index IF NOT EXISTS cz_m_leksem_xmlid
on cz_m_leksem( xmlid );"
                     )

    droptable :fraza_anot
    
    przepisz_tabelę( "create TABLE IF NOT EXISTS interpretacja(
   interpretacja_id integer primary key autoincrement,
   token_id integer not null,
   lex_xmlid text not null,
   msd_xmlid text not null,
   path_id integer not null,
   numer_lex_token integer,
   reszta_tagu text,
   leksem_id integer, 
   disamb boolean default 'f',
   dodana boolean default 'f', 
cz_m_leksem_id integer,
sensy_id integer,
   created_at timestamp, 
   updated_at timestamp );",

                     "create index IF NOT EXISTS interpretacja_leksem_id
on interpretacja( leksem_id );",

                     "create index IF NOT EXISTS interpretacja_token_id
on interpretacja( token_id );",

                     "create index if not exists interpretacja_disamb
on interpretacja( disamb );",

                     "create index if not exists interpretacja_token_id_disamb
on interpretacja( token_id, disamb );",
                     
                     "create unique index IF NOT EXISTS interpretacja_path_id_msd_xmlid
on interpretacja( path_id, msd_xmlid );"
                     )

    przepisz_tabelę( "create TABLE IF NOT EXISTS interpretacja_anot (
         interpretacja_anot_id integer primary key autoincrement,
	 akapit_transzy_id integer not null,
         uzytkownik_id integer not null,
         token_id integer not null,
         interpretacja_id integer not null,
	 created_at timestamp, 
	 updated_at timestamp);",

                     "create index IF NOT EXISTS interpretacja_anot_interpretacja_id
                     on interpretacja_anot( interpretacja_id );",

                     "create index IF NOT EXISTS interpretacja_anot_token_id
                     on interpretacja_anot (token_id);",

                     "create UNIQUE index if not exists interpretacja_anot_token_id_akapit_transzy_id
                     on interpretacja_anot (token_id, akapit_transzy_id);",

                     "create index IF NOT EXISTS interpretacja_anot_uzytkownik_id
                     on interpretacja_anot (uzytkownik_id);",

                     "create index IF NOT EXISTS interpretacja_anot_token_id_uzytkownik_id
                     on interpretacja_anot (token_id, uzytkownik_id);"
                     )


    przepisz_tabelę( "create TABLE IF NOT EXISTS klasa_gram(
klasa_gram_id integer primary key autoincrement,
cz_m_id integer,
klasa_gram_nazwa text,
klasa_gram_ozn text, 
klasa_sem text,
created_at timestamp,
updated_at timestamp);",

                     "create unique index IF NOT EXISTS klasa_gram_klasa_gram_ozn
on klasa_gram (klasa_gram_ozn);"
                     )


    przepisz_tabelę( "create TABLE IF NOT EXISTS komentarz(
komentarz_id integer primary key autoincrement,
akapit_id integer,
uzytkownik_id integer,
akapit_transzy_id integer,
przyczyna_odrzucenia integer default 0,
tresc text,
nowy boolean default 't',
created_at timestamp, 
updated_at timestamp);",

                     "create index IF NOT EXISTS komentarz_uzytkownik_id_akapit_id
on komentarz(uzytkownik_id, akapit_id);",

                     "create index IF NOT EXISTS komentarz_akapit_transzy_id
on komentarz(akapit_transzy_id);",

                     "create index IF NOT EXISTS komentarz_akapit_id
on komentarz(akapit_id);",

                     "create index IF NOT EXISTS komentarz_created_at
on komentarz(created_at);"
                     )


    przepisz_tabelę( "create TABLE IF NOT EXISTS leksem(
leksem_id integer primary key autoincrement,
lex_xmlid text not null,
path_id integer not null, -- to ma sens: do utożsamienia z~eltem \\rhtml{<fs type=\"lex\">} w~Korpusie.
lemat text,
klasa_gram_id integer,
cz_m_id integer, -- do sensowania (redundantne, 0+)
cz_m_leksem_id integer, -- do sensowania (0+)
created_at timestamp,
updated_at timestamp);",

                     "create unique index if not exists leksem_path_id_lex_xmlid
on leksem( path_id, lex_xmlid );",

                     "create index IF NOT EXISTS leksem_lemat_klasa_gram_id
on leksem (lemat, klasa_gram_id);",

                     "create unique index if not exists leksem_path_id_lemat_klasa_gram_id
on leksem( path_id, lemat, klasa_gram_id );"
                     )

przepisz_tabelę( "create TABLE IF NOT EXISTS morphosyntactic_rozbieznosc(
        morphosyntactic_rozbieznosc_id integer primary key autoincrement,
        token_id integer not null,
        interpretacja_id integer not null,
        reszta_tagu text,
        leksem_id integer not null,
	created_at timestamp,
	updated_at timestamp
);",

                 "create index IF NOT EXISTS morphosyntactic_rozbieznosc_token_id
      on morphosyntactic_rozbieznosc( token_id );"
                 )

    przepisz_tabelę( "create TABLE IF NOT EXISTS prosby_anotatorek( 
       prosby_anotatorek_id integer primary key autoincrement, 
       dotyczy_id integer not null, 
       dotyczy_type text not null,
       uzytkownik_id integer not null, 
       opis text, 
       created_at timestamp, 
       updated_at timestamp,
       rozpatrzona boolean default 'f',
       spelniona boolean);",

                     "create unique index if not exists prosby_anotatorek_dotyczy_type_dotyczy_id
on prosby_anotatorek( dotyczy_type, dotyczy_id);"
                     )

    przepisz_tabelę( "create table if not exists nowa_segmentacja(
       nowa_segmentacja_id integer primary key autoincrement,
       ids text,
       total_akapitow integer, -- == (select count(*) from akapit) ensured by a trigger
       seg_is text,
       seg_should_be text,
       nps boolean not null default 't',
       wprowadzona boolean default 'f'
);",

                     "create unique index if not exists nowa_segmentacja_seg_is_seg_should_be_ids_nps
on nowa_segmentacja( seg_is, seg_should_be, ids, nps );"
                     )

    ##    execute "drop trigger   nowa_segmentacja_total_akapitow"
    # trigger został unicestwiony wraz z~tabelą
    execute "create trigger  nowa_segmentacja_total_akapitow
        after insert on nowa_segmentacja
begin 
  update nowa_segmentacja set total_akapitow = (select count(*) from akapit) 
  where nowa_segmentacja_id = new.nowa_segmentacja_id;
end;"


przepisz_tabelę( "create TABLE IF NOT EXISTS poziomy_anotacji(
poziomy_anotacji_id integer primary key autoincrement,
uzytkownik_id integer not null,
segmentation boolean default 'f',
sentences boolean default 'f',
morphosyntactic boolean default 'f',
word_senses boolean default 'f',
syntactic_words boolean default 'f',
named_entities boolean default 'f',
syntactic boolean default 'f',
created_at timestamp, 
updated_at timestamp);",

"create unique index if not exists poziomy_anotacji_uzytkownik_id
on poziomy_anotacji( uzytkownik_id );"
)

przepisz_tabelę( "create TABLE IF NOT EXISTS protokol(
        protokol_id integer primary key autoincrement,
        poziom text not null,
        akapit_id integer not null,
        czy_rozbieznosc boolean not null default 't',
	czy_superancja boolean not null default 'f',
        created_at timestamp,
	updated_at timestamp
);",

"create index IF NOT EXISTS protokol_created_at
on protokol( created_at );",

"create index IF NOT EXISTS protokol_czy_rozbieznosc
      on protokol( czy_rozbieznosc );",

"create index IF NOT EXISTS protokol_poziom
      on protokol( poziom );",

"create index IF NOT EXISTS protokol_akapit_id
      on protokol( akapit_id );"
)


przepisz_tabelę( "create TABLE IF NOT EXISTS punkt_protokolu(
        punkt_protokolu_id integer primary key autoincrement,
        elt_protokol_id integer not null,
        elt_protokol_type text not null,
        protokol_id integer not null,
        akapit_transzy_id integer not null,
        uzytkownik_id integer,
	created_at timestamp, 
	updated_at timestamp);",

"create index IF NOT EXISTS punkt_protokolu_elt_protokol_id_elt_protokol_type
      on punkt_protokolu( elt_protokol_id, elt_protokol_type );",

"create index IF NOT EXISTS punkt_protokolu_protokol_id
      on punkt_protokolu( protokol_id );",

"create index IF NOT EXISTS punkt_protokolu_uzytkownik_id
      on punkt_protokolu( uzytkownik_id );",

"create index IF NOT EXISTS punkt_protokolu_akapit_transzy_id
      on punkt_protokolu( akapit_transzy_id );"
)


przepisz_tabelę( "create TABLE IF NOT EXISTS rola(
         opis text,
         rola_id integer primary key, 
	 opis_kr string,
	 created_at timestamp,
	 updated_at timestamp);" )


przepisz_tabelę( "create table if not exists sg_choice(
       sg_choice_id  integer primary key autoincrement,
       akapit_id integer not null, -- redundantne, dla łatwiejszego wyszukiwania
       dodany boolean default 'f',
       xmlid text,
       created_at timestamp, 
       updated_at timestamp
       );",

"create index if not exists sg_choice_akapit_id 
on sg_choice( akapit_id );"
)


przepisz_tabelę( "create table if not exists sg_variant_anot(
     sg_variant_anot_id  integer primary key autoincrement,
     sg_choice_id integer not null,
     sg_variant_id integer not null,
     chosen boolean not null,
     akapit_transzy_id integer not null,
     uzytkownik_id integer,     		        
     created_at timestamp,
     updated_at timestamp
);",

"create unique index if not exists -- żeby wymusić jednoznaczność ujednoznacznienia segmentacji
       sg_variant_anot_akapit_transzy_id_sg_variant_id
on sg_variant_anot( akapit_transzy_id, sg_variant_id);"
)


przepisz_tabelę( "create table if not exists sg_variant(
       sg_variant_id  integer primary key autoincrement,
       sg_choice_id integer not null,
       xmlid text,
       dodany boolean default 'f',
       created_at timestamp,
       updated_at timestamp
);",

"create index if not exists sg_variant_sg_choice_id
on sg_variant( sg_choice_id );"
)

przepisz_tabelę( "create TABLE IF NOT EXISTS segmentation_rozbieznosc(
        segmentation_rozbieznosc_id integer primary key autoincrement,
        sg_choice_id integer not null,
        sg_variant_id integer not null,
	created_at timestamp,
	updated_at timestamp
);",

"create index IF NOT EXISTS segmentation_rozbieznosc_sg_choice_id
      on segmentation_rozbieznosc( sg_choice_id );"
)


przepisz_tabelę( "create table if not exists koniec_zdania_anot(
       koniec_zdania_anot_id integer primary key autoincrement,
       akapit_id integer not null,
       akapit_transzy_id integer not null,
       uzytkownik_id integer not null,
       token_id integer not null,
       created_at timestamp,
       updated_at timestamp
       );",

" create unique index if not exists koniec_zdania_anot_akapit_transzy_id_token_id
on koniec_zdania_anot( akapit_transzy_id, token_id );",

" create index if not exists koniec_zdania_anot_akapit_id
on koniec_zdania_anot( akapit_id ); "
)


przepisz_tabelę( "create table if not exists sentences_rozbieznosc(
       sentences_rozbieznosc_id integer primary key autoincrement,
       token_id integer not null,
       czy_konczy_zdanie boolean not null,
       created_at timestamp,
       updated_at timestamp
);",

"create index if not exists sentences_rozbieznosc_token_id 
on sentences_rozbieznosc( token_id );"
)

przepisz_tabelę(
"create TABLE IF NOT EXISTS statusy(
      statusy_id integer primary key autoincrement,
      akapit_transzy_id integer not null,
      akapit_id integer not null,
      segmentation integer default -1,
      sentences integer default -1,
      morphosyntactic integer default -1,
      word_senses integer default -1,
      syntactic_words integer default -1,
      named_entities integer default -1,
      syntactic integer default -1,
      segmentation_uzid integer, 
      sentences_uzid integer,
      morphosyntactic_uzid integer, 
      word_senses_uzid integer, 
      syntactic_words_uzid integer, 
      named_entities_uzid integer, 
      syntactic_uzid integer, 
      segmentation_odrzucony boolean default 'f', 
      sentences_odrzucony boolean default 'f',
      morphosyntactic_odrzucony boolean default 'f', 
      word_senses_odrzucony boolean default 'f', 
      syntactic_words_odrzucony boolean default 'f', 
      named_entities_odrzucony boolean default 'f', 
      syntactic_odrzucony boolean default 'f',
      created_at timestamp, 
      updated_at timestamp);",

"create index IF NOT EXISTS statusy_morphosyntactic  on statusy(morphosyntactic);",
"create index IF NOT EXISTS statusy_named_entities  on statusy(named_entities);",
"create index IF NOT EXISTS statusy_segmentation  on statusy(segmentation);",
"create index IF NOT EXISTS statusy_sentences  on statusy(sentences);",
"create index IF NOT EXISTS statusy_syntactic  on statusy(syntactic);",
"create index IF NOT EXISTS statusy_syntactic_words  on statusy(syntactic_words);",
"create index IF NOT EXISTS statusy_word_senses  on statusy(word_senses);",

"create UNIQUE index if not exists statusy_akapit_transzy_id
on statusy( akapit_transzy_id );"
)

przepisz_tabelę( "create TABLE IF NOT EXISTS tagset(
       tagset_id integer primary key autoincrement,
       typ text,
       lewe text,
       prawe text,
       created_at timestamp,
       updated_at timestamp);",

"create index IF NOT EXISTS tagset_typ_lewe
on tagset(typ, lewe);"
)


przepisz_tabelę( "create TABLE IF NOT EXISTS token(
   token_id integer primary key autoincrement,
   kolejnosc integer, -- not null ensured by a trigger
   akapit_id integer not null,
   xpointer text,
   segmentation_xmlid text,
   morphosyntactic_xmlid text,
   fs_morph_comment text,
   path_id integer not null,
   orth text,
   czy_interp boolean not null,
   ns_poprzedza boolean default 'f', 
   ns_nastepuje boolean,
   czy_konczy_zdanie boolean,
   czy_konczy_zdanie_updated_at timestamp,
   sg_choice_id integer null default null,
   sg_variant_id integer null default null,
   dodany boolean default 'f' not null,
   chosen boolean default 't', -- dedukowalne z sg_variant_anot
   chosen_updated_at timestamp,
   superancja text, -- zserializowana tablica #\{[\\<poz_sym>*]\}
   created_at timestamp,
   updated_at timestamp
);",

"create unique index if not exists token_kolejnosc 
on token( kolejnosc );",

"create index if not exists token_ns_poprzedza
on token( ns_poprzedza );",

"create index if not exists token_ns_nastepuje
on token( ns_nastepuje );",

"create index IF NOT EXISTS token_akapit_id
on  token( akapit_id );",

"create unique index if not exists token_path_id_segmentation_xmlid
on token( path_id, segmentation_xmlid );",

"create index if not exists token_path_id_morphosyntactic_xmlid
on token( path_id, morphosyntactic_xmlid );",

"create index if not exists token_sg_choice_id
on token( sg_choice_id );",

"create index if not exists token_sg_variant_id
on token( sg_variant_id );",

"create index if not exists token_czy_interp 
on token( czy_interp );",

"create  index -- nie unique, bo tylko do wyszukiwania (przy danowlewie)
if not exists token_akapit_id_segmentation_xmlid_orth
on token( akapit_id, segmentation_xmlid, orth );"
)

## execute "drop trigger token_default_kolejnosc"
# trigger unicestwiony wraz z~tabelą
execute "create trigger  token_default_kolejnosc
        after insert on token 
	when (select kolejnosc from token where token_id = new.token_id) is null 
begin 
	update token set kolejnosc = (new.token_id * 216) 
	where token_id = new.token_id; 
end;"


przepisz_tabelę( "create TABLE IF NOT EXISTS transza(
   transza_id integer primary key autoincrement,
   uzytkownik_id integer,
   created_at timestamp,
   updated_at timestamp);",

"create index IF NOT EXISTS transza_uzytkownik_id
           on transza (uzytkownik_id);"
)

 przepisz_tabelę(  
"create TABLE IF NOT EXISTS akapit_transzy(
   akapit_transzy_id integer primary key autoincrement,
   akapit_id integer not null,
   transza_id integer not null,
   status integer default 0 not null, 
   odrzucony boolean default 'f', 
   uzytkownik_id integer, 
   created_at timestamp,
   updated_at timestamp,
   blizniaczy_id integer);",

"create index IF NOT EXISTS akapit_transzy_status 
       	on akapit_transzy( status );",

"create index IF NOT EXISTS akapit_transzy_transza_id
       	on akapit_transzy( transza_id );",

"create index IF NOT EXISTS akapit_transzy_uzytkownik_id
       	on akapit_transzy( uzytkownik_id );",

"create index IF NOT EXISTS akapit_transzy_akapit_id
       	on akapit_transzy( akapit_id );",

"create index IF NOT EXISTS akapit_transzy_odrzucony
       	on akapit_transzy( odrzucony );"
)

przepisz_tabelę(
"create TABLE IF NOT EXISTS akapit(
   akapit_id integer primary key autoincrement,
   morph_id integer not null,
   path_id integer not null, -- używane przy wyszukiwaniu akapitu podczas wczytywania \\file{sg.xml}.
   segmentation_xmlid text,
   segmentation_xlink_href text,
   morphosyntactic_xmlid text,
   created_at timestamp,
   updated_at timestamp
   );",

"create index if not exists akapit_morph_id
on akapit( morph_id );",

"create index if not exists akapit_path_id
on akapit( path_id );",

"create unique index if not exists akapit_path_id_segmentation_xmlid
on akapit( path_id, segmentation_xmlid );",

"create unique index if not exists akapit_path_id_morphosyntactic_xmlid
on akapit( path_id, morphosyntactic_xmlid );"
)

przepisz_tabelę(
"create table if not exists morph(
       morph_id integer primary key autoincrement,
       xmlid text not null,
       path_text text not null, -- identical as in table \\sql{path}
       created_at timestamp,
       updated_at timestamp
);",

"create unique index if not exists morph_xmlid_path_text
on morph( xmlid, path_text );"
)

przepisz_tabelę(
"create table if not exists path(
       path_id integer primary key autoincrement,
       path_text text not null,
       created_at timestamp,
       updated_at timestamp
       );",

"create unique index if not exists path_path_text on path( path_text );"
)


    przepisz_tabelę( "CREATE TABLE uzy.uzytkownik (
      uzytkownik_id integer primary key autoincrement,
      rola_id integer not null,
      login text not null,
      hasz_haslo text not null,
      sol text not null,
      imie text,
      nazwisko text,
      email text,
      jak_anotator boolean default 'f', -- dla zarządcy: czy ma mieć dostępność poziomów jak anotator, tj. po kolei w miarę zatwierdzania, czy wszystkich naraz.
      created_at timestamp ,
      updated_at timestamp, 
      haslo_updated_at timestamp);",

                     [ :login, :unique ]
                     )

pragmas_normal
    Uzytkownicy8003.connection.execute "vacuum"
    execute "vacuum"
    end # of #{if false}
      
  end # of #{self.up}

  def self.down
  end
end
