 #
 # This file is part of the Anotatornia suite.
 # 
 # Copyright © 2007, 2008, 2009, 2010 by Instytut Podstaw Informatyki
 # Polskiej Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 # Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 # 
 # This file may be distributed and/or modified under the terms of the
 # GNU General Public License version 3 as published by the Free Software
 # Foundation and appearing in the file COPYING included in the packaging
 # of this file.  (See http://www.gnu.org/licenses/translations.html for
 # unofficial translations.)
 # 
 # A commercial license is available from IPI PAN (contact
 # Michal.Ciesiolka.waw.pl or ipi.waw.pl for more
 # information).  Licensees holding a valid commercial license from IPI
 # PAN may use this file in accordance with that license.
 # 
 # This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 # THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 # PURPOSE.
 #

class SensAnotDopiszTokenId < ActiveRecord::Migration

  extend MigrationHelper

  def self.up
    pragmas_for_update

    unless SensAnot.column_names.include?( "token_id" )
      if SensAnot.count == 0
      przepisz_tabelę(
                      
                      'CREATE TABLE IF NOT EXISTS sens_anot(
-- Attributes --
   sens_anot_id integer primary key autoincrement,
   uzytkownik_id integer,
   akapit_transzy_id integer not null,
   token_id integer not null,
   interpretacja_id integer not null,
   sensy_id integer not null, 
   automatycznie boolean,
   created_at timestamp, -- default current_timestamp,
   updated_at timestamp);',

'CREATE INDEX IF NOT EXISTS sens_anot_sensy_id
on sens_anot( sensy_id );',

'CREATE INDEX IF NOT EXISTS sens_anot_interpretacja_id
on sens_anot( interpretacja_id );',

'CREATE INDEX IF NOT EXISTS sens_anot_token_id
on sens_anot( token_id );',

'CREATE INDEX IF NOT EXISTS sens_anot_interpretacja_id_akapit_transzy_id
on sens_anot( interpretacja_id, akapit_transzy_id );',

'CREATE INDEX IF NOT EXISTS sens_anot_akapit_transzy_id
on sens_anot( akapit_transzy_id );'
                      )
        errmess =  "SensAnot niepusty! nie mogę przepisać!"
        puts errmess
      else raise errmess
      end
    end    
    
    addindex :sens_anot, [ :akapit_transzy_id, :token_id] , :unique

    pragmas_normal
  end

  def self.down
  end
end
