 #
 # This file is part of the Anotatornia suite.
 # 
 # Copyright © 2007, 2008, 2009, 2010 by Instytut Podstaw Informatyki
 # Polskiej Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 # Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 # 
 # This file may be distributed and/or modified under the terms of the
 # GNU General Public License version 3 as published by the Free Software
 # Foundation and appearing in the file COPYING included in the packaging
 # of this file.  (See http://www.gnu.org/licenses/translations.html for
 # unofficial translations.)
 # 
 # A commercial license is available from IPI PAN (contact
 # Michal.Ciesiolka.waw.pl or ipi.waw.pl for more
 # information).  Licensees holding a valid commercial license from IPI
 # PAN may use this file in accordance with that license.
 # 
 # This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 # THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 # PURPOSE.
 #

class StatusyPoprawWsd < ActiveRecord::Migration

  extend MigrationHelper

  def self.up
    ak_od_do = Token.find_by_sql( " select min( akapit_id) as ak_od, max( akapit_id ) as ak_do from token where exists (select interpretacja_id from interpretacja i where cz_m_leksem_id is not null and i.token_id=token.token_id and disamb='t') and (not exists (select sens_anot_id from sens_anot sa where sa.token_id=token.token_id)) and (select min(word_senses) from statusy s where s.akapit_id=token.akapit_id)>=16 ;" ).collect { |t198| [t198.ak_od.to_i, t198.ak_do.to_i ] }.flatten

    kill_anotatorniæ_if_8003
    
    execute "update statusy set word_senses=0 where akapit_id in (select distinct akapit_id  from token where exists (select interpretacja_id from interpretacja i where cz_m_leksem_id is not null and i.token_id=token.token_id and disamb='t') and (not exists (select sens_anot_id from sens_anot sa where sa.token_id=token.token_id)) and (select min(word_senses) from statusy s where s.akapit_id=token.akapit_id)>=16) ;"
    
    AkapitTranszy.update_all_Stati( *ak_od_do )

  end

  def self.down
  end
end
