 #
 # This file is part of the Anotatornia suite.
 # 
 # Copyright © 2007, 2008, 2009, 2010 by Instytut Podstaw Informatyki
 # Polskiej Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 # Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 # 
 # This file may be distributed and/or modified under the terms of the
 # GNU General Public License version 3 as published by the Free Software
 # Foundation and appearing in the file COPYING included in the packaging
 # of this file.  (See http://www.gnu.org/licenses/translations.html for
 # unofficial translations.)
 # 
 # A commercial license is available from IPI PAN (contact
 # Michal.Ciesiolka.waw.pl or ipi.waw.pl for more
 # information).  Licensees holding a valid commercial license from IPI
 # PAN may use this file in accordance with that license.
 # 
 # This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 # THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 # PURPOSE.
 #

class PoprawInterpretacjaLeksem < ActiveRecord::Migration

  extend MigrationHelper


  def self.up

    execute "analyze"
    execute "vacuum"

    ##    addindex :interpretacja, :path_id
    ##    addindex :leksem, :path_id

    if Interpretacja.find_by_sql(
                                 " select * from interpretacja i inner join leksem l using( leksem_id )" +
                                 "where i.path_id<>l.path_id limit 1" )[0]
      # poprawiamy przypisanie #{leksem}ów z nie tej ścieżki      
      
      kill_anotatorniæ_if_8003

      # na wypadek, gdyby ta poprawka okazała się błędem, zapisujemy co było przed nią.
      execute "create table if not exists interpretacja_bef47_bad_leksem( " +
        " interpretacja_id integer primary key, " +
        " leksem_id integer );"

      
      Interpretacja.find_all_by_dodana( true ).each { |i218|
        le218 = i218.leksem

        conds = { 
          :lemat => le218.lemat,
          :path_id => i218.path_id,
          :klasa_gram_id => le218.klasa_gram_id
        }


        le219 = Leksem.find( :first, :conditions => conds )
        le219 ||= Leksem.create!( conds.update(
                                               :lex_xmlid => i218.lex_xmlid
                                               ))
        if le218 != le219

          execute "insert into interpretacja_bef47_bad_leksem " +
            " values( #{i218.id}, #{i218.leksem_id} )"

          i218.leksem = le219
          i218.save!
          ##          puts "#{i218.path_id} #{i218.id}"
        end  
      }
      
    end

    if Interpretacja.find_by_sql( 
                                 " select * from interpretacja i1 inner join interpretacja i2 " +
                                 " using( token_id, leksem_id ) " +
                                 " where i1.lex_xmlid<>i2.lex_xmlid limit 1 " )[0]
      # poprawiamy zawyżony (niepotrzebnie unikatowy) #{lex_xmlid}


      # na wypadek, gdyby ta poprawka okazała się błędem, zapisujemy co było przed nią.
      execute "create table if not exists interpretacja_bef47_bad_xmlids( " +
        " interpretacja_id integer primary key, " +
        " lex_xmlid text, " +
        " msd_xmlid text, " +
        " numer_lex_token integer );"

      Interpretacja.find_all_by_dodana( true ).each { |i218|
        
        # szukamy oryginalnej interpretacji z naszego lexa.
        conds218 = " token_id = #{i218.token_id} and leksem_id = #{i218.leksem_id} and interpretacja_id<>#{i218.id} "

        i219 = Interpretacja.find( :first, :conditions => conds218 )
        if i219 and 
            i219.lex_xmlid != i218.lex_xmlid

          execute "insert into interpretacja_bef47_bad_xmlids " +
            " values( #{i218.id}, '#{i218.lex_xmlid}', " +
            " '#{i218.msd_xmlid}', #{i218.numer_lex_token} ) "

          # poprawiamy też #{msd_xmlid}

          msd_id = Interpretacja.find( :all, :conditions => conds218 ).
            collect { |il| il.msd_xmlid.split('.')[-1].to_i }.
            compact.max + 1
          
          ##          puts "#{i218.path_id} #{i218.id}"

          i218.lex_xmlid = i219.lex_xmlid
          i218.msd_xmlid = "#{i219.lex_xmlid}.#{msd_id}"
          i218.numer_lex_token = msd_id
          i218.save!        
        end
      }
    end


  end # of #{self.up}

  def self.down
  end
end
