 #
 # This file is part of the Anotatornia suite.
 # 
 # Copyright © 2007, 2008, 2009, 2010 by Instytut Podstaw Informatyki
 # Polskiej Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 # Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 # 
 # This file may be distributed and/or modified under the terms of the
 # GNU General Public License version 3 as published by the Free Software
 # Foundation and appearing in the file COPYING included in the packaging
 # of this file.  (See http://www.gnu.org/licenses/translations.html for
 # unofficial translations.)
 # 
 # A commercial license is available from IPI PAN (contact
 # Michal.Ciesiolka.waw.pl or ipi.waw.pl for more
 # information).  Licensees holding a valid commercial license from IPI
 # PAN may use this file in accordance with that license.
 # 
 # This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 # THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 # PURPOSE.
 #

class PoprawXpointery < ActiveRecord::Migration

  extend MigrationHelper

  def self.up
    if AnoVersion.nkjp?
      kill_anotatorniæ_if_8003
      
      addindex :token, :dodany
      
      execute "analyze"
      
      SgVariant.tokododane.each { |sgv|
        unless [ 2513, 2528 ].include?( sgv.id )  # ręcznie oporządzane »8,3kg« i »5,5kg«. Poprawimy ręcznie dalej.
          sgv.popraw_xpointers
        end
      }
      
      
      # ręcznie zmodyfikowany sgv. 2513
      Token.ustaw_xpointer_na( 553380,  "string-range(txt_1.1-ab,47,3)" )
      Token.ustaw_xpointer_na( 553366,  "string-range(txt_1.1-ab,50,2)" )
      # razem konsumują 6 znaków (ze spacją) tekstu wejściowego
      
      # ręcznie zmodyfikowany sgv. 2528
      Token.ustaw_xpointer_na( 553393,  "string-range(txt_1.1-ab,70,3)" ) # 5,5
      Token.ustaw_xpointer_na( 553364,  "string-range(txt_1.1-ab,73,3)" ) # kg 
      # razem konsumują 6 znaków tekstu wejściowego.
      
    end    
  end # of #{self.up}
  
  def self.down
  end
end
