 #
 # This file is part of the Anotatornia suite.
 # 
 # Copyright © 2007, 2008, 2009, 2010 by Instytut Podstaw Informatyki
 # Polskiej Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 # Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 # 
 # This file may be distributed and/or modified under the terms of the
 # GNU General Public License version 3 as published by the Free Software
 # Foundation and appearing in the file COPYING included in the packaging
 # of this file.  (See http://www.gnu.org/licenses/translations.html for
 # unofficial translations.)
 # 
 # A commercial license is available from IPI PAN (contact
 # Michal.Ciesiolka.waw.pl or ipi.waw.pl for more
 # information).  Licensees holding a valid commercial license from IPI
 # PAN may use this file in accordance with that license.
 # 
 # This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 # THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 # PURPOSE.
 #

class PoprawSegm10391 < ActiveRecord::Migration
  extend MigrationHelper

  def self.up
    if AnoVersion.nkjp? 
      kill_anotatorniæ_if_8003


      pa = ProsbyAnotatorek.new( 
                                :uzytkownik_id => Uzytkownik.natror.id,
                                :opis => "#346, zgł. przez interpreting",
                                :dotyczy =>       
                                NowaSegmentacja.new(
                                                    :ids => [ 10391 ],
                                                    :total_akapitow => 17,
                                                    :seg_is => [ "31października" ],
                                                    :seg_should_be       => %w( 31 października ),
                                                    :nps => false, # separated with a space
                                                    :wprowadzona => false,
                                                    :akapit_transzy_id   => 20784,
                                                    :transza_id => 2079
                                                    )
                                )
      
      pa.save!
      
    end
    
    
  end # of #{up}

  def self.down
  end
end
