# This file is autogenerated. Instead of editing this file, please use the
# migrations feature of ActiveRecord to incrementally modify your database, and
# then regenerate this schema definition.

ActiveRecord::Schema.define(:version => 4) do

  create_table "corpus_path", :id => false, :force => true do |t|
    t.column "corpus_path_id", :integer
    t.column "path",           :text
  end

  add_index "corpus_path", ["path"], :name => "corpus_path_path"

  create_table "cz_m", :id => false, :force => true do |t|
    t.column "cz_m_id",    :integer
    t.column "cz_m_nazwa", :text
  end

  create_table "czasownik_auto", :id => false, :force => true do |t|
    t.column "czasownik_auto_id", :integer
    t.column "bezokolicznik",     :text
    t.column "ile_zdan_cz",       :integer
  end

  create_table "fraza_anot", :id => false, :force => true do |t|
    t.column "fraza_anot_id",    :integer
    t.column "zdanie_id",        :integer
    t.column "uzytkownik_id",    :integer
    t.column "nr_wyr_pocz",      :integer
    t.column "nr_wyr_kon",       :integer
    t.column "token_id_synhead", :integer
    t.column "token_id_semhead", :integer
    t.column "fraza_typ_id",     :integer
    t.column "vp_typ",           :integer
    t.column "sie_typ",          :integer
  end

  create_table "fraza_typ", :id => false, :force => true do |t|
    t.column "fraza_typ_id", :integer
    t.column "typ_opis",     :text
    t.column "typ_symbol",   :text
    t.column "cz_m_synhead", :integer
    t.column "cz_m_semhead", :integer
  end

  create_table "interpretacja", :id => false, :force => true do |t|
    t.column "interpretacja_id", :integer
    t.column "token_id",         :integer
    t.column "disamb",           :boolean
    t.column "numer_lex_token",  :integer
    t.column "reszta_tagu",      :text
    t.column "leksem_id",        :integer
  end

  add_index "interpretacja", ["numer_lex_token"], :name => "interpretacja_numer_lex_token"
  add_index "interpretacja", ["token_id"], :name => "interpretacja_token_id"

  create_table "interpretacja_anot", :id => false, :force => true do |t|
    t.column "opis_morf_anot_id", :integer
    t.column "uzytkownik_id",     :integer
    t.column "interpretacja_id",  :integer
  end

  create_table "klasa_gram", :id => false, :force => true do |t|
    t.column "klasa_gram_id",    :integer
    t.column "cz_m_id",          :integer
    t.column "klasa_gram_nazwa", :text
    t.column "klasa_gram_ozn",   :text
  end

  add_index "klasa_gram", ["klasa_gram_ozn"], :name => "klasa_gram_klasa_gram_ozn"

  create_table "komentarz", :id => false, :force => true do |t|
    t.column "komentarz_id",  :integer
    t.column "zdanie_id",     :integer
    t.column "uzytkownik_id", :integer
    t.column "nr_kom_zd",     :integer
    t.column "tresc",         :text
    t.column "temat",         :integer
  end

  create_table "leksem", :id => false, :force => true do |t|
    t.column "leksem_id",     :integer
    t.column "lemat",         :text
    t.column "klasa_gram_id", :integer
  end

  add_index "leksem", ["lemat", "klasa_gram_id"], :name => "leksem_lemat_klasa_gram_id"

  create_table "plik_morph", :id => false, :force => true do |t|
    t.column "plik_morph_id", :integer
    t.column "abs_path",      :text
    t.column "ile_zdan",      :integer
  end

  create_table "rola", :id => false, :force => true do |t|
    t.column "opis",    :text
    t.column "rola_id", :integer
    t.column "opis_kr", :string,  :limit => nil
  end

  create_table "sens", :id => false, :force => true do |t|
    t.column "sens_id",   :integer
    t.column "sens_opis", :text
    t.column "sens_ozn",  :text
    t.column "cz_m_id",   :integer
  end

  create_table "sens_anot", :id => false, :force => true do |t|
    t.column "sens_anot_id",     :integer
    t.column "uzytkownik_id",    :integer
    t.column "token_id",         :integer
    t.column "sensy_leksemu_id", :integer
  end

  create_table "sensy_leksemu", :id => false, :force => true do |t|
    t.column "sensy_leksemu_id", :integer
    t.column "sens_id",          :integer
    t.column "leksem_id",        :integer
    t.column "nowy",             :boolean
    t.column "liczba_uzyc",      :integer
  end

  create_table "session", :force => true do |t|
    t.column "session_id", :string
    t.column "data",       :text
    t.column "updated_at", :datetime
  end

  add_index "session", ["updated_at"], :name => "index_session_on_updated_at"
  add_index "session", ["session_id"], :name => "index_session_on_session_id"

# Could not dump table "sqlite_sequence" because of following StandardError
#   Unknown type '' for column 'name'

  create_table "status_zd_auto", :id => false, :force => true do |t|
    t.column "status_id",     :integer
    t.column "zdanie_id",     :integer
    t.column "uzytkownik_id", :integer
    t.column "moment",        :integer
  end

  create_table "token", :id => false, :force => true do |t|
    t.column "token_id",     :integer
    t.column "zdanie_id",    :integer
    t.column "nr_wyrazu_zd", :integer
    t.column "orth",         :text
    t.column "tok_id_morph", :integer
    t.column "czy_interp",   :boolean
    t.column "ns_poprzedza", :boolean
  end

  add_index "token", ["nr_wyrazu_zd"], :name => "token_nr_wyrazu_zd"
  add_index "token", ["zdanie_id"], :name => "token_zdanie_id"

  create_table "transza_auto", :id => false, :force => true do |t|
    t.column "transza_auto_id",   :integer
    t.column "uzytkownik_id",     :integer
    t.column "czasownik_auto_id", :integer
    t.column "czy_zakonczona",    :integer
    t.column "prosba_odebrania",  :integer
    t.column "przyczyna_prosby",  :text
    t.column "czy_aktualna",      :integer
    t.column "ile_zdan_tr",       :integer
  end

  create_table "uzytkownik", :id => false, :force => true do |t|
    t.column "uzytkownik_id",          :integer
    t.column "rola_id",                :integer, :null => false
    t.column "login",                  :text,    :null => false
    t.column "hasz_haslo",             :text,    :null => false
    t.column "sol",                    :text,    :null => false
    t.column "imie",                   :text
    t.column "nazwisko",               :text
    t.column "ile_razy_zaanotowal",    :integer
    t.column "ile_zd_zweryfikowanych", :integer
  end

  create_table "zdania_transzy", :id => false, :force => true do |t|
    t.column "zdanie_id",       :integer
    t.column "transza_auto_id", :integer
  end

  create_table "zdanie", :id => false, :force => true do |t|
    t.column "zdanie_id",            :integer
    t.column "czy_zweryfikowane",    :integer
    t.column "ile_weryfikacji_auto", :integer
    t.column "czy_osadzone",         :integer
    t.column "czy_arbitralnie",      :integer
    t.column "ktora_weryf_aut_ok",   :integer
    t.column "got_do_weryf_recznej", :integer
    t.column "got_do_osadzenia",     :integer
    t.column "nr_morph_chunk_p",     :integer
    t.column "nr_morph_chunk_s",     :integer
    t.column "plik_morph_id",        :integer
    t.column "corpus_path_id",       :integer
    t.column "czasownik_auto_id",    :integer
    t.column "nr_zdania_czasow",     :integer
    t.column "data_zatwierdzenia",   :datetime
  end

  add_index "zdanie", ["corpus_path_id"], :name => "zdanie_corpus_path_id"

end
