#!/usr/bin/perl


# Converts a "temporary TEI" morphosyntax (output of Anotatornia) to target TEI. Minor changes, mostly xi:include->corresp.

open INTEXT, "<$ARGV[0]";
open OUTTEXT, ">$ARGV[1]";


while (<INTEXT>) {

    s#(<teiCorpus.*) xmlns:xlink.*>#$1>#;
    s#(<teiCorpus.*) xmlns:nkjp=".*?"(.*)>#$1$2>#;
    s/<s xlink:href=(".*?")/<s corresp=$1/;
    s/<p xlink:href=(".*?")/<p corresp=$1/;
    s/<seg xlink:href=(".*?")/<seg corresp=$1/;
    s/<fs type="tool_report">/<fs feats="#an8003" type="tool_report">/;
    
    unless (/^<\?o/) {
	print OUTTEXT;
    }
    
}

close INTEXT;
close OUTTEXT;

