CREATE TABLE akapit(
   akapit_id integer primary key autoincrement,
   morph_id integer not null,
   path_id integer not null, -- używane przy wyszukiwaniu akapitu podczas wczytywania \file{sg.xml}.
   segmentation_xmlid text,
   segmentation_xlink_href text,
   morphosyntactic_xmlid text,
   created_at timestamp,
   updated_at timestamp
   , tresc  text, incipit  text);
CREATE TABLE akapit_transzy(
   akapit_transzy_id integer primary key autoincrement,
   akapit_id integer not null,
   transza_id integer not null,
   status integer default 0 not null, 
   odrzucony boolean default 'f', 
   uzytkownik_id integer, 
   created_at timestamp,
   updated_at timestamp,
   blizniaczy_id integer);
CREATE TABLE cz_m(
-- Attributes --
cz_m_id integer primary key autoincrement,
cz_m_ozn text, 
created_at timestamp,
updated_at timestamp);
CREATE TABLE cz_m_leksem(
-- Attributes --
cz_m_leksem_id integer primary key autoincrement,
lemat text not null,
xmlid text not null,
cz_m_id integer not null,
created_at timestamp,
updated_at timestamp);
CREATE TABLE fraza_typ(
-- Attributes --
fraza_typ_id integer primary key autoincrement,
typ_opis text,
typ_symbol text,
synhead_list text,
semhead_list text, 
jednoglowa boolean,
created_at timestamp default current_timestamp,
updated_at timestamp);
CREATE TABLE interpretacja(
   interpretacja_id integer primary key autoincrement,
   token_id integer not null,
   lex_xmlid text not null,
   msd_xmlid text not null,
   path_id integer not null,
   numer_lex_token integer,
   reszta_tagu text,
   leksem_id integer, 
   disamb boolean default 'f',
   dodana boolean default 'f', 
cz_m_leksem_id integer,
sensy_id integer,
   created_at timestamp, 
   updated_at timestamp , cz_m_leksem_przypisany  boolean default 'f');
CREATE TABLE interpretacja_anot (
         interpretacja_anot_id integer primary key autoincrement,
	 akapit_transzy_id integer not null,
         uzytkownik_id integer not null,
         token_id integer not null,
         interpretacja_id integer not null,
	 created_at timestamp, 
	 updated_at timestamp);
CREATE TABLE interpretacja_bef47_bad_leksem(  interpretacja_id integer primary key,  leksem_id integer );
CREATE TABLE interpretacja_bef47_bad_xmlids(  interpretacja_id integer primary key,  lex_xmlid text,  msd_xmlid text,  numer_lex_token integer );
CREATE TABLE klasa_gram(
klasa_gram_id integer primary key autoincrement,
cz_m_id integer,
klasa_gram_nazwa text,
klasa_gram_ozn text, 
klasa_sem text,
created_at timestamp,
updated_at timestamp);
CREATE TABLE komentarz(
komentarz_id integer primary key autoincrement,
akapit_id integer,
uzytkownik_id integer,
akapit_transzy_id integer,
przyczyna_odrzucenia integer default 0,
tresc text,
nowy boolean default 't',
created_at timestamp, 
updated_at timestamp);
CREATE TABLE koniec_zdania_anot(
       koniec_zdania_anot_id integer primary key autoincrement,
       akapit_id integer not null,
       akapit_transzy_id integer not null,
       uzytkownik_id integer not null,
       token_id integer not null,
       created_at timestamp,
       updated_at timestamp
       );
CREATE TABLE leksem(
leksem_id integer primary key autoincrement,
lex_xmlid text not null,
path_id integer not null, -- to ma sens: do utożsamienia z~eltem \rhtml{<fs type="lex">} w~Korpusie.
lemat text,
klasa_gram_id integer,
cz_m_id integer, -- do sensowania (redundantne, 0+)
cz_m_leksem_id integer, -- do sensowania (0+)
created_at timestamp,
updated_at timestamp, cz_m_przypisana  boolean default 'f', cz_m_leksem_przypisany  boolean default 'f');
CREATE TABLE morph(
       morph_id integer primary key autoincrement,
       xmlid text not null,
       path_text text not null, -- identical as in table \sql{path}
       created_at timestamp,
       updated_at timestamp
);
CREATE TABLE morphosyntactic_rozbieznosc(
        morphosyntactic_rozbieznosc_id integer primary key autoincrement,
        token_id integer not null,
        interpretacja_id integer not null,
        reszta_tagu text,
        leksem_id integer not null,
	created_at timestamp,
	updated_at timestamp
);
CREATE TABLE nowa_segmentacja(
       nowa_segmentacja_id integer primary key autoincrement,
       ids text,
       total_akapitow integer, -- == (select count(*) from akapit) ensured by a trigger
       seg_is text,
       seg_should_be text,
       nps boolean not null default 't',
       wprowadzona boolean default 'f'
, akapit_transzy_id  integer, transza_id  integer);
CREATE TABLE path(
       path_id integer primary key autoincrement,
       path_text text not null,
       created_at timestamp,
       updated_at timestamp
       );
CREATE TABLE poziomy_anotacji(
poziomy_anotacji_id integer primary key autoincrement,
uzytkownik_id integer not null,
segmentation boolean default 'f',
sentences boolean default 'f',
morphosyntactic boolean default 'f',
word_senses boolean default 'f',
syntactic_words boolean default 'f',
named_entities boolean default 'f',
syntactic boolean default 'f',
created_at timestamp, 
updated_at timestamp);
CREATE TABLE prosby_anotatorek( 
       prosby_anotatorek_id integer primary key autoincrement, 
       dotyczy_id integer not null, 
       dotyczy_type text not null,
       uzytkownik_id integer not null, 
       opis text, 
       created_at timestamp, 
       updated_at timestamp,
       rozpatrzona boolean default 'f',
       spelniona boolean);
CREATE TABLE protokol(
        protokol_id integer primary key autoincrement,
        poziom text not null,
        akapit_id integer not null,
        czy_rozbieznosc boolean not null default 't',
	czy_superancja boolean not null default 'f',
        created_at timestamp,
	updated_at timestamp
);
CREATE TABLE punkt_protokolu(
        punkt_protokolu_id integer primary key autoincrement,
        elt_protokol_id integer not null,
        elt_protokol_type text not null,
        protokol_id integer not null,
        akapit_transzy_id integer not null,
        uzytkownik_id integer,
	created_at timestamp, 
	updated_at timestamp);
CREATE TABLE rola(
         opis text,
         rola_id integer primary key, 
	 opis_kr string,
	 created_at timestamp,
	 updated_at timestamp);
CREATE TABLE schema_info (version integer);
CREATE TABLE segmentation_rozbieznosc(
        segmentation_rozbieznosc_id integer primary key autoincrement,
        sg_choice_id integer not null,
        sg_variant_id integer not null,
	created_at timestamp,
	updated_at timestamp
);
CREATE TABLE sens_anot(
-- Attributes --
   sens_anot_id integer primary key autoincrement,
   uzytkownik_id integer,
   akapit_transzy_id integer not null,
   token_id integer not null,
   interpretacja_id integer not null,
   sensy_id integer not null, 
   automatycznie boolean,
   created_at timestamp, -- default current_timestamp,
   updated_at timestamp);
CREATE TABLE sensy(
-- Attributes --
   sensy_id integer primary key autoincrement,
   cz_m_id integer not null,
   cz_m_leksem_id integer not null, 
   xmlid text,
   n integer, -- przy wlewie sprawdzamy czy lemat.odpolszcz.n == xmlid
   short_def text,
   long_def_xml text,
   long_def_html text,
   created_at timestamp,
   updated_at timestamp
);
CREATE TABLE sentences_rozbieznosc(
       sentences_rozbieznosc_id integer primary key autoincrement,
       token_id integer not null,
       czy_konczy_zdanie boolean not null,
       created_at timestamp,
       updated_at timestamp
);
CREATE TABLE session(
       "id" INTEGER PRIMARY KEY NOT NULL, 
       "session_id" varchar(255) DEFAULT NULL,
        "data" text DEFAULT NULL, 
	"updated_at" datetime DEFAULT NULL);
CREATE TABLE sg_choice(
       sg_choice_id  integer primary key autoincrement,
       akapit_id integer not null, -- redundantne, dla łatwiejszego wyszukiwania
       dodany boolean default 'f',
       xmlid text,
       created_at timestamp, 
       updated_at timestamp
       );
CREATE TABLE sg_variant(
       sg_variant_id  integer primary key autoincrement,
       sg_choice_id integer not null,
       xmlid text,
       dodany boolean default 'f',
       created_at timestamp,
       updated_at timestamp
);
CREATE TABLE sg_variant_anot(
     sg_variant_anot_id  integer primary key autoincrement,
     sg_choice_id integer not null,
     sg_variant_id integer not null,
     chosen boolean not null,
     akapit_transzy_id integer not null,
     uzytkownik_id integer,     		        
     created_at timestamp,
     updated_at timestamp
);
CREATE TABLE statusy(
      statusy_id integer primary key autoincrement,
      akapit_transzy_id integer not null,
      akapit_id integer not null,
      segmentation integer default -1,
      sentences integer default -1,
      morphosyntactic integer default -1,
      word_senses integer default -1,
      syntactic_words integer default -1,
      named_entities integer default -1,
      syntactic integer default -1,
      segmentation_uzid integer, 
      sentences_uzid integer,
      morphosyntactic_uzid integer, 
      word_senses_uzid integer, 
      syntactic_words_uzid integer, 
      named_entities_uzid integer, 
      syntactic_uzid integer, 
      segmentation_odrzucony boolean default 'f', 
      sentences_odrzucony boolean default 'f',
      morphosyntactic_odrzucony boolean default 'f', 
      word_senses_odrzucony boolean default 'f', 
      syntactic_words_odrzucony boolean default 'f', 
      named_entities_odrzucony boolean default 'f', 
      syntactic_odrzucony boolean default 'f',
      created_at timestamp, 
      updated_at timestamp, transza_id  integer);
CREATE TABLE tagset(
       tagset_id integer primary key autoincrement,
       typ text,
       lewe text,
       prawe text,
       created_at timestamp,
       updated_at timestamp);
CREATE TABLE token(
   token_id integer primary key autoincrement,
   kolejnosc integer, -- not null ensured by a trigger
   akapit_id integer not null,
   xpointer text,
   segmentation_xmlid text,
   morphosyntactic_xmlid text,
   fs_morph_comment text,
   path_id integer not null,
   orth text,
   czy_interp boolean not null,
   ns_poprzedza boolean default 'f', 
   ns_nastepuje boolean,
   czy_konczy_zdanie boolean,
   czy_konczy_zdanie_updated_at timestamp,
   sg_choice_id integer null default null,
   sg_variant_id integer null default null,
   dodany boolean default 'f' not null,
   chosen boolean default 't', -- dedukowalne z sg_variant_anot
   chosen_updated_at timestamp,
   superancja text, -- zserializowana tablica #{[\<poz_sym>*]}
   created_at timestamp,
   updated_at timestamp
);
CREATE TABLE transza(
   transza_id integer primary key autoincrement,
   uzytkownik_id integer,
   created_at timestamp,
   updated_at timestamp);
CREATE TABLE word_senses_rozbieznosc(
        word_senses_rozbieznosc_id integer primary key autoincrement,
	token_id integer not null,
        sensy_id integer not null,
	created_at timestamp, 
	updated_at timestamp
);
CREATE VIEW interpretacja_export as
select interpretacja_id as interpretacja_export_id, 
interpretacja.*, 
lemat, klasa_gram_ozn 
from interpretacja inner join leksem using( leksem_id )
inner join klasa_gram using( klasa_gram_id ) 
where interpretacja.dodana='f' or interpretacja.disamb='t'
order by numer_lex_token, interpretacja_id;
CREATE INDEX akapit_morph_id
on akapit( morph_id );
CREATE INDEX akapit_path_id
on akapit( path_id );
CREATE UNIQUE INDEX akapit_path_id_morphosyntactic_xmlid
on akapit( path_id, morphosyntactic_xmlid );
CREATE UNIQUE INDEX akapit_path_id_segmentation_xmlid
on akapit( path_id, segmentation_xmlid );
CREATE INDEX akapit_transzy_akapit_id
       	on akapit_transzy( akapit_id );
CREATE INDEX akapit_transzy_odrzucony
       	on akapit_transzy( odrzucony );
CREATE INDEX akapit_transzy_status 
       	on akapit_transzy( status );
CREATE INDEX akapit_transzy_transza_id
       	on akapit_transzy( transza_id );
CREATE INDEX akapit_transzy_uzytkownik_id
       	on akapit_transzy( uzytkownik_id );
CREATE UNIQUE INDEX cz_m_leksem_lemat_cz_m_id on cz_m_leksem( lemat, cz_m_id);
CREATE UNIQUE INDEX cz_m_leksem_xmlid on cz_m_leksem( xmlid);
CREATE INDEX "index_session_on_session_id" ON session( "session_id" );
CREATE INDEX "index_session_on_updated_at" ON session( "updated_at" );
CREATE INDEX interpretacja_anot_interpretacja_id
                     on interpretacja_anot( interpretacja_id );
CREATE INDEX interpretacja_anot_token_id
                     on interpretacja_anot (token_id);
CREATE UNIQUE INDEX interpretacja_anot_token_id_akapit_transzy_id
                     on interpretacja_anot (token_id, akapit_transzy_id);
CREATE INDEX interpretacja_anot_token_id_uzytkownik_id
                     on interpretacja_anot (token_id, uzytkownik_id);
CREATE INDEX interpretacja_anot_uzytkownik_id
                     on interpretacja_anot (uzytkownik_id);
CREATE INDEX interpretacja_created_at on interpretacja( created_at);
CREATE INDEX interpretacja_cz_m_leksem_id on interpretacja( cz_m_leksem_id);
CREATE INDEX interpretacja_cz_m_leksem_przypisany on interpretacja( cz_m_leksem_przypisany);
CREATE INDEX interpretacja_disamb
on interpretacja( disamb );
CREATE INDEX interpretacja_leksem_id
on interpretacja( leksem_id );
CREATE UNIQUE INDEX interpretacja_path_id_msd_xmlid
on interpretacja( path_id, msd_xmlid );
CREATE INDEX interpretacja_token_id
on interpretacja( token_id );
CREATE INDEX interpretacja_token_id_disamb
on interpretacja( token_id, disamb );
CREATE UNIQUE INDEX klasa_gram_klasa_gram_ozn
on klasa_gram (klasa_gram_ozn);
CREATE INDEX komentarz_akapit_id
on komentarz(akapit_id);
CREATE INDEX komentarz_akapit_transzy_id
on komentarz(akapit_transzy_id);
CREATE INDEX komentarz_created_at
on komentarz(created_at);
CREATE INDEX komentarz_uzytkownik_id_akapit_id
on komentarz(uzytkownik_id, akapit_id);
CREATE INDEX koniec_zdania_anot_akapit_id
on koniec_zdania_anot( akapit_id );
CREATE UNIQUE INDEX koniec_zdania_anot_akapit_transzy_id_token_id
on koniec_zdania_anot( akapit_transzy_id, token_id );
CREATE INDEX leksem_created_at on leksem( created_at);
CREATE INDEX leksem_cz_m_leksem_id on leksem( cz_m_leksem_id);
CREATE INDEX leksem_cz_m_leksem_przypisany on leksem( cz_m_leksem_przypisany);
CREATE INDEX leksem_cz_m_przypisana on leksem( cz_m_przypisana);
CREATE INDEX leksem_lemat_klasa_gram_id
on leksem (lemat, klasa_gram_id);
CREATE UNIQUE INDEX leksem_path_id_lemat_klasa_gram_id
on leksem( path_id, lemat, klasa_gram_id );
CREATE UNIQUE INDEX leksem_path_id_lex_xmlid
on leksem( path_id, lex_xmlid );
CREATE UNIQUE INDEX morph_xmlid_path_text
on morph( xmlid, path_text );
CREATE INDEX morphosyntactic_rozbieznosc_token_id
      on morphosyntactic_rozbieznosc( token_id );
CREATE INDEX nowa_segmentacja_akapit_transzy_id on nowa_segmentacja( akapit_transzy_id);
CREATE UNIQUE INDEX nowa_segmentacja_seg_is_seg_should_be_ids_nps
on nowa_segmentacja( seg_is, seg_should_be, ids, nps );
CREATE INDEX nowa_segmentacja_transza_id on nowa_segmentacja( transza_id);
CREATE UNIQUE INDEX path_path_text on path( path_text );
CREATE UNIQUE INDEX poziomy_anotacji_uzytkownik_id
on poziomy_anotacji( uzytkownik_id );
CREATE UNIQUE INDEX prosby_anotatorek_dotyczy_type_dotyczy_id
on prosby_anotatorek( dotyczy_type, dotyczy_id);
CREATE INDEX protokol_akapit_id
      on protokol( akapit_id );
CREATE INDEX protokol_created_at
on protokol( created_at );
CREATE INDEX protokol_czy_rozbieznosc
      on protokol( czy_rozbieznosc );
CREATE INDEX protokol_poziom
      on protokol( poziom );
CREATE INDEX punkt_protokolu_akapit_transzy_id
      on punkt_protokolu( akapit_transzy_id );
CREATE INDEX punkt_protokolu_elt_protokol_id_elt_protokol_type
      on punkt_protokolu( elt_protokol_id, elt_protokol_type );
CREATE INDEX punkt_protokolu_protokol_id
      on punkt_protokolu( protokol_id );
CREATE INDEX punkt_protokolu_uzytkownik_id
      on punkt_protokolu( uzytkownik_id );
CREATE INDEX segmentation_rozbieznosc_sg_choice_id
      on segmentation_rozbieznosc( sg_choice_id );
CREATE INDEX sens_anot_akapit_transzy_id
on sens_anot( akapit_transzy_id );
CREATE UNIQUE INDEX sens_anot_akapit_transzy_id_token_id on sens_anot( akapit_transzy_id, token_id);
CREATE INDEX sens_anot_interpretacja_id
on sens_anot( interpretacja_id );
CREATE INDEX sens_anot_interpretacja_id_akapit_transzy_id
on sens_anot( interpretacja_id, akapit_transzy_id );
CREATE INDEX sens_anot_sensy_id
on sens_anot( sensy_id );
CREATE INDEX sens_anot_token_id
on sens_anot( token_id );
CREATE INDEX sensy_cz_m_id on sensy( cz_m_id);
CREATE UNIQUE INDEX sensy_xmlid on sensy( xmlid);
CREATE INDEX sentences_rozbieznosc_token_id 
on sentences_rozbieznosc( token_id );
CREATE INDEX sg_choice_akapit_id 
on sg_choice( akapit_id );
CREATE UNIQUE INDEX sg_variant_anot_akapit_transzy_id_sg_variant_id
on sg_variant_anot( akapit_transzy_id, sg_variant_id);
CREATE INDEX sg_variant_sg_choice_id
on sg_variant( sg_choice_id );
CREATE INDEX statusy_akapit_id on statusy( akapit_id);
CREATE UNIQUE INDEX statusy_akapit_transzy_id
on statusy( akapit_transzy_id );
CREATE INDEX statusy_morphosyntactic  on statusy(morphosyntactic);
CREATE INDEX statusy_named_entities  on statusy(named_entities);
CREATE INDEX statusy_segmentation  on statusy(segmentation);
CREATE INDEX statusy_sentences  on statusy(sentences);
CREATE INDEX statusy_syntactic  on statusy(syntactic);
CREATE INDEX statusy_syntactic_words  on statusy(syntactic_words);
CREATE INDEX statusy_transza_id on statusy( transza_id);
CREATE INDEX statusy_word_senses  on statusy(word_senses);
CREATE INDEX tagset_typ_lewe
on tagset(typ, lewe);
CREATE INDEX token_akapit_id
on  token( akapit_id );
CREATE INDEX token_akapit_id_orth on token( akapit_id, orth);
CREATE INDEX token_akapit_id_segmentation_xmlid_orth
on token( akapit_id, segmentation_xmlid, orth );
CREATE INDEX token_czy_interp 
on token( czy_interp );
CREATE INDEX token_dodany on token( dodany);
CREATE UNIQUE INDEX token_kolejnosc 
on token( kolejnosc );
CREATE INDEX token_ns_nastepuje
on token( ns_nastepuje );
CREATE INDEX token_ns_poprzedza
on token( ns_poprzedza );
CREATE INDEX token_orth on token( orth);
CREATE INDEX token_path_id_morphosyntactic_xmlid
on token( path_id, morphosyntactic_xmlid );
CREATE UNIQUE INDEX token_path_id_segmentation_xmlid
on token( path_id, segmentation_xmlid );
CREATE INDEX token_sg_choice_id
on token( sg_choice_id );
CREATE INDEX token_sg_variant_id
on token( sg_variant_id );
CREATE INDEX transza_uzytkownik_id
           on transza (uzytkownik_id);
CREATE INDEX word_senses_rozbieznosc_token_id
      on word_senses_rozbieznosc( token_id );
CREATE TRIGGER nowa_segmentacja_total_akapitow
        after insert on nowa_segmentacja
begin 
  update nowa_segmentacja set total_akapitow = (select count(*) from akapit) 
  where nowa_segmentacja_id = new.nowa_segmentacja_id;
end;
CREATE TRIGGER token_default_kolejnosc
        after insert on token 
	when (select kolejnosc from token where token_id = new.token_id) is null 
begin 
	update token set kolejnosc = (new.token_id * 216) 
	where token_id = new.token_id; 
end;
