'''
Created on 01-10-2011

@author: lennyn
'''

from django import forms
from bibmate.helpers.import_utils import check_bibtex
from bibmate.helpers.exceptions import BibtexException

class ImportForm(forms.Form):
    bibtex = forms.FileField()
    
    def clean_bibtex(self):
        f = self.cleaned_data.get('bibtex')
        bibtex_text = f.read()
        try:
            check_bibtex(bibtex_text)
        except BibtexException as ex:
            raise forms.ValidationError(ex.msg)
        return bibtex_text
    
class UploadForm(forms.Form):
    pdf  = forms.FileField()

class SimpleSearchForm(forms.Form):
    searchBy = forms.ChoiceField(label='', 
                                 choices=[
                                          ('author', 'Author'),
                                          ('title', 'Title'),
                                          ('year', 'Year'),
                                          ])
    argument = forms.CharField(label='')

class AdvancedSearchForm(forms.Form):
    author = forms.CharField(initial='Author:')
    author_ignore_case = forms.BooleanField(initial='Ignore case:')
    author_what = forms.ChoiceField(choices=[
                                             ('equal', 'is equal'),
                                             ('contains', 'contains'),
                                             ('starts_with', 'starts with'),
                                             ])
    title = forms.CharField(initial='Title:')
    title_ignore_case = forms.BooleanField(initial='Ignore case:')
    title_what = forms.ChoiceField(choices=[
                                             ('equal', 'is equal'),
                                             ('contains', 'contains'),
                                             ('starts_with', 'starts with'),
                                             ])
    year = forms.IntegerField(initial='Year:')

class UploadPdfForm(forms.Form):
    pub_id = forms.HiddenInput()
    title = forms.CharField(max_length=50)
    pdf  = forms.FileField()
    
