'''
Created on 04-11-2011

@author: mlenart
'''
import codecs
from django.core.management.base import BaseCommand, CommandError
from bibmate.helpers import import_utils

class Command(BaseCommand):
    
    args = '<bibtex filename>'
    help = 'Imports publications from specified file'

    def handle(self, filename, *args, **kwargs):
        f = codecs.open(filename, 'r', 'utf-8')
        try:
            import_utils.import_bibtex(f.read())
        finally:
            f.close()
        self.stdout.write('DONE import')
    