#!/bin/bash

PROJECT_ROOT=`pwd`
DJANGO_PID="$PROJECT_ROOT/django.pid"
HOST=127.0.0.1
PORT=3033
DAEMONIZE=true
ERR=$HOME/var/log/bibmate_test.err
OUT=$HOME/var/log/bibmate_test.out

function killDjango {
    if [ -f $DJANGO_PID ]; then
        kill `cat -- $DJANGO_PID`
        rm -f -- $DJANGO_PID
    fi
}

killDjango

python manage.py runfcgi host=$HOST port=$PORT \
    method=threaded \
    pidfile=$DJANGO_PID \
    daemonize=$DAEMONIZE \
    errlog=$ERR \
    outlog=$OUT

