import os
from django.conf.urls.defaults import patterns, include, url
from django.conf.urls.static import static
from django.contrib.staticfiles.urls import staticfiles_urlpatterns
# Uncomment the next two lines to enable the admin:
from django.contrib import admin, auth
import settings
admin.autodiscover()

urlpatterns = patterns('',
    url(r'^$', 'bibmate.views.index', name='index'),
    url(r'^list/', 'bibmate.views.index', {'template_name': 'publicationsList.html'}, name='list'),
    url(r'^import/', 'bibmate.views.import_pub', name='import'),
    url(r'^advancedSearch', 'bibmate.views.advancedSearch', name='advancedSearch'),
    url(r'^about/', 'bibmate.views.about', name='about'),
    url(r'^edit/(?P<pub_id>.*)', 'bibmate.views.edit', name='edit'),
    url(r'^edit/(?P<pub_id>.*)', 'bibmate.views.edit', name='upload'),
    url(r'^bibtex/(?P<pub_id>.*)', 'bibmate.views.bibtex', name='bibtex'),
    url(r'^bibtex_aggregate/', 'bibmate.views.bibtex_aggregate', name='bibtex_aggregate'),
    url(r'^deletePublication/(?P<pub_id>.*)', 'bibmate.views.deletePublication', name='deletePublication'),
    url(r'^deletePdf/(?P<pub_id>.*)', 'bibmate.views.deletePdf', name='deletePdf'),
    url(r'^download/(?P<pub_id>.*)', 'bibmate.views.download', name='download'),
    url(r'^login/', 'django.contrib.auth.views.login', {'template_name': 'login.html'}, 'login'),
    url(r'^logout/', 'django.contrib.auth.views.logout', {}, 'logout'),

    # Uncomment the admin/doc line below to enable admin documentation:
     url(r'^admin/doc/', include('django.contrib.admindocs.urls')),

    # Uncomment the next line to enable the admin:
     url(r'^admin/', include(admin.site.urls)),
)

urlpatterns += staticfiles_urlpatterns()
