/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.shef.wit.simmetrics.similaritymetrics;

import java.io.Serializable;
import uk.ac.shef.wit.simmetrics.math.MathFuncs;
import uk.ac.shef.wit.simmetrics.similaritymetrics.AbstractStringMetric;
import uk.ac.shef.wit.simmetrics.similaritymetrics.costfunctions.AbstractSubstitutionCost;
import uk.ac.shef.wit.simmetrics.similaritymetrics.costfunctions.SubCost01;

public final class NeedlemanWunch
extends AbstractStringMetric
implements Serializable {
    private final float ESTIMATEDTIMINGCONST = 1.842E-4f;
    private AbstractSubstitutionCost dCostFunc;
    private float gapCost;

    public NeedlemanWunch() {
        this.gapCost = 2.0f;
        this.dCostFunc = new SubCost01();
    }

    public NeedlemanWunch(float costG) {
        this.gapCost = costG;
        this.dCostFunc = new SubCost01();
    }

    public NeedlemanWunch(float costG, AbstractSubstitutionCost costFunc) {
        this.gapCost = costG;
        this.dCostFunc = costFunc;
    }

    public NeedlemanWunch(AbstractSubstitutionCost costFunc) {
        this.gapCost = 2.0f;
        this.dCostFunc = costFunc;
    }

    public float getGapCost() {
        return this.gapCost;
    }

    public void setGapCost(float gapCost) {
        this.gapCost = gapCost;
    }

    public AbstractSubstitutionCost getdCostFunc() {
        return this.dCostFunc;
    }

    public void setdCostFunc(AbstractSubstitutionCost dCostFunc) {
        this.dCostFunc = dCostFunc;
    }

    public String getShortDescriptionString() {
        return "NeedlemanWunch";
    }

    public String getLongDescriptionString() {
        return "Implements the Needleman-Wunch algorithm providing an edit distance based similarity measure between two strings";
    }

    public String getSimilarityExplained(String string1, String string2) {
        return null;
    }

    public float getSimilarityTimingEstimated(String string1, String string2) {
        float str1Length = string1.length();
        float str2Length = string2.length();
        return str1Length * str2Length * 1.842E-4f;
    }

    public float getSimilarity(String string1, String string2) {
        float maxValue;
        float needlemanWunch = this.getUnNormalisedSimilarity(string1, string2);
        float minValue = maxValue = (float)Math.max(string1.length(), string2.length());
        maxValue = this.dCostFunc.getMaxCost() > this.gapCost ? (maxValue *= this.dCostFunc.getMaxCost()) : (maxValue *= this.gapCost);
        minValue = this.dCostFunc.getMinCost() < this.gapCost ? (minValue *= this.dCostFunc.getMinCost()) : (minValue *= this.gapCost);
        if (minValue < 0.0f) {
            maxValue -= minValue;
            needlemanWunch -= minValue;
        }
        if (maxValue == 0.0f) {
            return 1.0f;
        }
        return 1.0f - needlemanWunch / maxValue;
    }

    public float getUnNormalisedSimilarity(String s, String t) {
        int j;
        int i;
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        float[][] d = new float[n + 1][m + 1];
        for (i = 0; i <= n; ++i) {
            d[i][0] = i;
        }
        for (j = 0; j <= m; ++j) {
            d[0][j] = j;
        }
        for (i = 1; i <= n; ++i) {
            for (j = 1; j <= m; ++j) {
                float cost = this.dCostFunc.getCost(s, i - 1, t, j - 1);
                d[i][j] = MathFuncs.min3(d[i - 1][j] + this.gapCost, d[i][j - 1] + this.gapCost, d[i - 1][j - 1] + cost);
            }
        }
        return d[n][m];
    }
}

