/*
 * Decompiled with CFR 0.152.
 */
package com.nestor.interpret.expression;

import com.nestor.interpret.expression.Expression;
import com.nestor.interpret.expression.Operator;
import com.nestor.interpret.expression.RefinedValueParser;
import com.nestor.interpret.expression.Value;
import com.nestor.interpret.parse.ParseEnv;
import com.nestor.interpret.parse.ParseException;
import com.nestor.interpret.parse.Parser;
import com.nestor.interpret.parse.Scanner;
import com.nestor.interpret.token.MultiToken;
import com.nestor.interpret.token.Token;
import com.nestor.interpret.type.DATA;
import com.nestor.interpret.type.TYPE;
import java.util.ArrayList;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExpressionParser<VAL extends DATA>
extends RefinedValueParser<VAL> {
    private final MultiToken operations;

    public ExpressionParser(TYPE<VAL> valueClass, Parser<? extends Value> subparser, Token ... operations) {
        super(valueClass, subparser);
        this.operations = new MultiToken(Arrays.asList(operations));
    }

    private Value<VAL> createExpressionMatch(Operator<VAL, VAL> operation, Value<VAL> left, Value<VAL> right) {
        ArrayList<Value<VAL>> values = new ArrayList<Value<VAL>>();
        values.add(left);
        values.add(right);
        return new Expression<VAL>(operation, values);
    }

    protected abstract Operator<VAL, VAL> getOperator(Token var1);

    @Override
    public final Value parse(Scanner scanner, ParseEnv env) throws ParseException {
        Token operation;
        Value leftValue = (Value)super.seekCompatibleMatch(scanner, env);
        Value left = super.castIfValueCompatible(leftValue);
        if (left == null) {
            return leftValue;
        }
        while ((operation = this.operations.matchAdvance(scanner)) != null) {
            Value right = super.requireCompatibleValue(scanner, env);
            left = this.createExpressionMatch(this.getOperator(operation), left, right);
        }
        return left;
    }
}

