/*
 * Decompiled with CFR 0.152.
 */
package com.nestor.interpret.expression.arithmetic;

import com.nestor.interpret.expression.AbstractOperator;
import com.nestor.interpret.expression.EvaluationException;
import com.nestor.interpret.expression.arithmetic.ArithmeticTokens;
import com.nestor.interpret.token.Token;
import com.nestor.interpret.type.DOUBLE;
import com.nestor.interpret.type.INTEGER;
import com.nestor.interpret.type.NUMBER;
import com.nestor.interpret.type.TYPE;
import com.nestor.interpret.type.TYPES;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ArithmeticOperator
extends AbstractOperator<NUMBER, NUMBER> {
    private static final long serialVersionUID = 1L;
    public static final ArithmeticOperator ADDITION = new ArithmeticOperator(ArithmeticTokens.PLUS){
        private static final long serialVersionUID = 6883611857263050776L;

        @Override
        public NUMBER operation(NUMBER total, NUMBER next) throws EvaluationException {
            if (total instanceof INTEGER && next instanceof INTEGER) {
                return new INTEGER(total.intValue() + next.intValue());
            }
            return new DOUBLE(total.doubleValue() + next.doubleValue());
        }

        @Override
        public TYPE<? extends NUMBER> resultType(Collection<TYPE<? extends NUMBER>> types) {
            return 1.standardResultType(types);
        }
    };
    public static final ArithmeticOperator DIVISION = new ArithmeticOperator(ArithmeticTokens.DIV){
        private static final long serialVersionUID = 6602261183518998036L;

        @Override
        public NUMBER operation(NUMBER total, NUMBER next) throws EvaluationException {
            try {
                if (total instanceof INTEGER && next instanceof INTEGER) {
                    return new INTEGER(total.intValue() / next.intValue());
                }
                return new DOUBLE(total.doubleValue() / next.doubleValue());
            }
            catch (ArithmeticException e) {
                throw new EvaluationException(e);
            }
        }

        @Override
        public TYPE<? extends NUMBER> resultType(Collection<TYPE<? extends NUMBER>> types) {
            return 2.standardResultType(types);
        }
    };
    public static final ArithmeticOperator DIVISION_INT = new ArithmeticOperator(ArithmeticTokens.DIV_INT){
        private static final long serialVersionUID = 2946870172647024805L;

        @Override
        public NUMBER operation(NUMBER total, NUMBER next) throws EvaluationException {
            try {
                return new INTEGER((int)(total.doubleValue() / next.doubleValue()));
            }
            catch (ArithmeticException e) {
                throw new EvaluationException(e);
            }
        }

        @Override
        public TYPE<? extends NUMBER> resultType(Collection<TYPE<? extends NUMBER>> types) {
            return TYPES.INTEGER_TYPE;
        }
    };
    public static final ArithmeticOperator MULTIPLICATION = new ArithmeticOperator(ArithmeticTokens.TIMES){
        private static final long serialVersionUID = 8441644507864634036L;

        @Override
        public NUMBER operation(NUMBER total, NUMBER next) throws EvaluationException {
            if (total instanceof INTEGER && next instanceof INTEGER) {
                return new INTEGER(total.intValue() * next.intValue());
            }
            return new DOUBLE(total.doubleValue() * next.doubleValue());
        }

        @Override
        public TYPE<? extends NUMBER> resultType(Collection<TYPE<? extends NUMBER>> types) {
            return 4.standardResultType(types);
        }
    };
    public static final ArithmeticOperator POWERING = new ArithmeticOperator(ArithmeticTokens.POWER){
        private static final long serialVersionUID = -6763566821237159082L;

        @Override
        public NUMBER operation(NUMBER total, NUMBER next) throws EvaluationException {
            if (total instanceof INTEGER && next instanceof INTEGER) {
                return new INTEGER((int)Math.pow(total.intValue(), next.intValue()));
            }
            return new DOUBLE(Math.pow(total.doubleValue(), next.doubleValue()));
        }

        @Override
        public TYPE<? extends NUMBER> resultType(Collection<TYPE<? extends NUMBER>> types) {
            return 5.standardResultType(types);
        }
    };
    public static final ArithmeticOperator SUBSTRACTION = new ArithmeticOperator(ArithmeticTokens.MINUS){
        private static final long serialVersionUID = -3268237261487364214L;

        @Override
        public NUMBER operation(NUMBER total, NUMBER next) throws EvaluationException {
            if (total instanceof INTEGER && next instanceof INTEGER) {
                return new INTEGER(total.intValue() - next.intValue());
            }
            return new DOUBLE(total.doubleValue() - next.doubleValue());
        }

        @Override
        public TYPE<? extends NUMBER> resultType(Collection<TYPE<? extends NUMBER>> types) {
            return 6.standardResultType(types);
        }
    };
    public static final ArithmeticOperator MODULO = new ArithmeticOperator(ArithmeticTokens.MODULO){
        private static final long serialVersionUID = 2515218061274547090L;

        @Override
        public NUMBER operation(NUMBER total, NUMBER next) throws EvaluationException {
            try {
                if (total instanceof INTEGER && next instanceof INTEGER) {
                    return new INTEGER(total.intValue() % next.intValue());
                }
                return new DOUBLE(total.doubleValue() % next.doubleValue());
            }
            catch (ArithmeticException e) {
                throw new EvaluationException(e);
            }
        }

        @Override
        public TYPE<? extends NUMBER> resultType(Collection<TYPE<? extends NUMBER>> types) {
            return 7.standardResultType(types);
        }
    };

    public static ArithmeticOperator getOperator(Token operationToken) {
        if (operationToken.isSame(ArithmeticTokens.PLUS)) {
            return ADDITION;
        }
        if (operationToken.isSame(ArithmeticTokens.MINUS)) {
            return SUBSTRACTION;
        }
        if (operationToken.isSame(ArithmeticTokens.TIMES)) {
            return MULTIPLICATION;
        }
        if (operationToken.isSame(ArithmeticTokens.DIV)) {
            return DIVISION;
        }
        if (operationToken.isSame(ArithmeticTokens.DIV_INT)) {
            return DIVISION_INT;
        }
        if (operationToken.isSame(ArithmeticTokens.POWER)) {
            return POWERING;
        }
        if (operationToken.isSame(ArithmeticTokens.MODULO)) {
            return MODULO;
        }
        throw new IllegalArgumentException("Unknown operation");
    }

    public ArithmeticOperator(Token operationToken) {
        super(operationToken.describe());
    }

    protected static TYPE<? extends NUMBER> standardResultType(Collection<TYPE<? extends NUMBER>> types) {
        TYPE<? extends NUMBER> result = null;
        for (TYPE<? extends NUMBER> type : types) {
            result = result == null ? type : NUMBER.getBestBaseType(result, type);
        }
        return result;
    }
}

