/*
 * Decompiled with CFR 0.152.
 */
package com.nestor.interpret.expression.arithmetic;

import com.nestor.interpret.expression.EvaluationException;
import com.nestor.interpret.expression.RuntimeEnv;
import com.nestor.interpret.expression.Value;
import com.nestor.interpret.expression.arithmetic.ArithmeticTokens;
import com.nestor.interpret.type.DOUBLE;
import com.nestor.interpret.type.INTEGER;
import com.nestor.interpret.type.NUMBER;
import com.nestor.interpret.type.TYPE;
import com.nestor.interpret.type.TYPES;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NegativeExpression
implements Value<NUMBER> {
    private static final long serialVersionUID = 4375675944510300103L;
    private final Value<? extends NUMBER> negated;

    public NegativeExpression(Value<? extends NUMBER> negated) {
        this.negated = negated;
    }

    @Override
    public String describe() {
        return String.valueOf(ArithmeticTokens.MINUS.describe()) + this.negated.describe();
    }

    @Override
    public NUMBER evaluate(RuntimeEnv arg) throws EvaluationException {
        if (TYPES.INTEGER_TYPE.isAssignableFrom(this.negated.getValueType())) {
            return new INTEGER(-this.negated.evaluate(arg).intValue());
        }
        if (TYPES.DOUBLE_TYPE.isAssignableFrom(this.negated.getValueType())) {
            return new DOUBLE(-this.negated.evaluate(arg).intValue());
        }
        throw new IllegalArgumentException("Unknown value type");
    }

    @Override
    public TYPE<? extends NUMBER> getValueType() {
        return this.negated.getValueType();
    }
}

