/*
 * Decompiled with CFR 0.152.
 */
package com.nestor.interpret.expression.bool;

import com.nestor.interpret.expression.AbstractOperator;
import com.nestor.interpret.expression.EvaluationException;
import com.nestor.interpret.expression.bool.BooleanTokens;
import com.nestor.interpret.token.Token;
import com.nestor.interpret.type.BOOLEAN;
import com.nestor.interpret.type.TYPE;
import com.nestor.interpret.type.TYPES;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BooleanOperator
extends AbstractOperator<BOOLEAN, BOOLEAN> {
    private static final long serialVersionUID = 1L;
    public static final BooleanOperator ALTERNATIVE = new BooleanOperator(BooleanTokens.OR){
        private static final long serialVersionUID = -4267880699572077783L;

        public BOOLEAN operation(BOOLEAN total, BOOLEAN next) throws EvaluationException {
            return new BOOLEAN(total.booleanValue() || next.booleanValue());
        }
    };
    public static final BooleanOperator CONJUNCTION = new BooleanOperator(BooleanTokens.AND){
        private static final long serialVersionUID = 2710295965100731100L;

        public BOOLEAN operation(BOOLEAN total, BOOLEAN next) throws EvaluationException {
            return new BOOLEAN(total.booleanValue() && next.booleanValue());
        }
    };
    public static final BooleanOperator EXCLUSION = new BooleanOperator(BooleanTokens.XOR){
        private static final long serialVersionUID = -2486523920450690213L;

        public BOOLEAN operation(BOOLEAN total, BOOLEAN next) throws EvaluationException {
            return new BOOLEAN(total.booleanValue() ^ next.booleanValue());
        }
    };
    public static final BooleanOperator IDENTITY = new BooleanOperator(BooleanTokens.IDENTITY){
        private static final long serialVersionUID = 8088015789299989812L;

        public BOOLEAN operation(BOOLEAN total, BOOLEAN next) throws EvaluationException {
            return new BOOLEAN(total.booleanValue() == next.booleanValue());
        }
    };
    public static final BooleanOperator IMPLICATION = new BooleanOperator(BooleanTokens.IMPLY){
        private static final long serialVersionUID = -9043525379482547547L;

        public final BOOLEAN operation(BOOLEAN total, BOOLEAN next) throws EvaluationException {
            return new BOOLEAN(!total.booleanValue() || next.booleanValue());
        }
    };

    public static BooleanOperator getOperator(Token operationToken) {
        if (operationToken.isSame(BooleanTokens.AND)) {
            return CONJUNCTION;
        }
        if (operationToken.isSame(BooleanTokens.OR)) {
            return ALTERNATIVE;
        }
        if (operationToken.isSame(BooleanTokens.XOR)) {
            return EXCLUSION;
        }
        if (operationToken.isSame(BooleanTokens.IDENTITY)) {
            return IDENTITY;
        }
        if (operationToken.isSame(BooleanTokens.IMPLY)) {
            return IMPLICATION;
        }
        throw new IllegalArgumentException("Unknown operation");
    }

    public BooleanOperator(Token operationToken) {
        super(operationToken.describe());
    }

    @Override
    public final TYPE<? extends BOOLEAN> resultType(Collection<TYPE<? extends BOOLEAN>> types) {
        return TYPES.BOOLEAN_TYPE;
    }
}

