/*
 * Decompiled with CFR 0.152.
 */
package com.nestor.interpret.expression.bool;

import com.nestor.interpret.expression.EvaluationException;
import com.nestor.interpret.expression.RuntimeEnv;
import com.nestor.interpret.expression.Value;
import com.nestor.interpret.expression.bool.BooleanTokens;
import com.nestor.interpret.type.BOOLEAN;
import com.nestor.interpret.type.TYPE;
import com.nestor.interpret.type.TYPES;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IdentityExpression
implements Value<BOOLEAN> {
    private static final long serialVersionUID = 1009848142869669440L;
    private final Collection<Value<BOOLEAN>> values;

    public IdentityExpression(Collection<Value<BOOLEAN>> values) {
        this.values = values;
    }

    @Override
    public String describe() {
        String res = null;
        for (Value<BOOLEAN> value : this.values) {
            res = res == null ? value.describe() : String.valueOf(BooleanTokens.IDENTITY.describe()) + value.describe();
        }
        return res;
    }

    @Override
    public BOOLEAN evaluate(RuntimeEnv arg) throws EvaluationException {
        BOOLEAN previous = null;
        for (Value<BOOLEAN> value : this.values) {
            if (previous == null) {
                previous = value.evaluate(arg);
                continue;
            }
            if (value.evaluate(arg).booleanValue() == previous.booleanValue()) continue;
            return BOOLEAN.FALSE;
        }
        return BOOLEAN.TRUE;
    }

    @Override
    public TYPE<? extends BOOLEAN> getValueType() {
        return TYPES.BOOLEAN_TYPE;
    }
}

