/*
 * Decompiled with CFR 0.152.
 */
package com.nestor.interpret.expression.bool;

import com.nestor.interpret.expression.EvaluationException;
import com.nestor.interpret.expression.RuntimeEnv;
import com.nestor.interpret.expression.Value;
import com.nestor.interpret.expression.bool.BooleanTokens;
import com.nestor.interpret.type.BOOLEAN;
import com.nestor.interpret.type.TYPE;
import com.nestor.interpret.type.TYPES;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NegationExpression
implements Value<BOOLEAN> {
    private static final long serialVersionUID = 6577486254984448508L;
    private final Value<BOOLEAN> negated;

    public NegationExpression(Value<BOOLEAN> negated) {
        this.negated = negated;
    }

    @Override
    public String describe() {
        return String.valueOf(BooleanTokens.NOT.describe()) + this.negated.describe();
    }

    @Override
    public BOOLEAN evaluate(RuntimeEnv arg) throws EvaluationException {
        return new BOOLEAN(!this.negated.evaluate(arg).booleanValue());
    }

    @Override
    public TYPE<? extends BOOLEAN> getValueType() {
        return TYPES.BOOLEAN_TYPE;
    }
}

