/*
 * Decompiled with CFR 0.152.
 */
package com.nestor.interpret.expression.relational;

import com.nestor.interpret.expression.RefinedValueParser;
import com.nestor.interpret.expression.Value;
import com.nestor.interpret.expression.relational.RelationalExpression;
import com.nestor.interpret.expression.relational.RelationalOperator;
import com.nestor.interpret.expression.relational.RelationalTokens;
import com.nestor.interpret.parse.ParseEnv;
import com.nestor.interpret.parse.ParseException;
import com.nestor.interpret.parse.Parser;
import com.nestor.interpret.parse.Scanner;
import com.nestor.interpret.token.Token;
import com.nestor.interpret.type.NUMBER;
import com.nestor.interpret.type.TYPES;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RelationalExpressionParser
extends RefinedValueParser<NUMBER> {
    public RelationalExpressionParser(Parser<? extends Value> subparser) {
        super(TYPES.NUMBER_TYPE, subparser);
    }

    @Override
    public String describe() {
        return "relational expression";
    }

    private RelationalOperator getOperator(Token operationToken) {
        return RelationalOperator.getOperator(operationToken);
    }

    @Override
    public Value parse(Scanner scanner, ParseEnv env) throws ParseException {
        Token operation;
        Value firstValue = (Value)super.seekCompatibleMatch(scanner, env);
        Value first = super.castIfValueCompatible(firstValue);
        if (first == null) {
            return firstValue;
        }
        RelationalExpression equation = null;
        while ((operation = RelationalTokens.ALL.matchAdvance(scanner)) != null) {
            Value next = super.requireCompatibleValue(scanner, env);
            RelationalOperator operator = this.getOperator(operation);
            if (equation == null) {
                equation = new RelationalExpression(operator, first, next);
                continue;
            }
            equation = new RelationalExpression(operator, equation, next);
        }
        if (equation == null) {
            return first;
        }
        return equation;
    }
}

