/*
 * Decompiled with CFR 0.152.
 */
package com.nestor.interpret.expression.string;

import com.nestor.interpret.expression.RefinedValueParser;
import com.nestor.interpret.expression.Value;
import com.nestor.interpret.expression.arithmetic.ArithmeticTokens;
import com.nestor.interpret.expression.string.Concatenation;
import com.nestor.interpret.parse.ParseEnv;
import com.nestor.interpret.parse.ParseException;
import com.nestor.interpret.parse.Parser;
import com.nestor.interpret.parse.Scanner;
import com.nestor.interpret.type.STRING;
import com.nestor.interpret.type.TYPES;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConcatenationParser
extends RefinedValueParser<STRING> {
    public ConcatenationParser(Parser<? extends Value> subparser) {
        super(TYPES.STRING_TYPE, subparser);
    }

    @Override
    public String describe() {
        return "string expression";
    }

    @Override
    public Value parse(Scanner scanner, ParseEnv env) throws ParseException {
        Value value = (Value)super.seekCompatibleMatch(scanner, env);
        Value stringValue = super.castIfValueCompatible(value);
        if (stringValue == null) {
            return value;
        }
        if (scanner.matchAdvance(ArithmeticTokens.PLUS) == null) {
            return value;
        }
        ArrayList<Value<STRING>> strings = new ArrayList<Value<STRING>>();
        strings.add(stringValue);
        do {
            Value next = super.requireCompatibleValue(scanner, env);
            strings.add(next);
        } while (scanner.matchAdvance(ArithmeticTokens.PLUS) != null);
        return new Concatenation(strings);
    }
}

