/*
 * Decompiled with CFR 0.152.
 */
package com.nestor.interpret.expression.string;

import com.nestor.interpret.expression.RefinedValueParser;
import com.nestor.interpret.expression.Value;
import com.nestor.interpret.expression.relational.RelationalTokens;
import com.nestor.interpret.expression.string.Comparison;
import com.nestor.interpret.parse.ParseEnv;
import com.nestor.interpret.parse.ParseException;
import com.nestor.interpret.parse.Parser;
import com.nestor.interpret.parse.Scanner;
import com.nestor.interpret.type.STRING;
import com.nestor.interpret.type.TYPES;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringEqualityParser
extends RefinedValueParser<STRING> {
    public StringEqualityParser(Parser<? extends Value> subparser) {
        super(TYPES.STRING_TYPE, subparser);
    }

    @Override
    public String describe() {
        return "string comparison";
    }

    @Override
    public Value parse(Scanner scanner, ParseEnv env) throws ParseException {
        Value value = (Value)super.seekCompatibleMatch(scanner, env);
        Value<STRING> stringValue = super.castIfValueCompatible(value);
        if (stringValue == null) {
            return value;
        }
        if (scanner.matchAdvance(RelationalTokens.EQUAL) != null) {
            Value<STRING> rightSide = super.requireCompatibleValue(scanner, env);
            return new Comparison(stringValue, rightSide);
        }
        return value;
    }
}

