/*
 * Decompiled with CFR 0.152.
 */
package com.nestor.interpret.jbasic;

import com.nestor.interpret.jbasic.JBasicProgram;
import com.nestor.interpret.jbasic.lang.ModuleBuilder;
import com.nestor.interpret.jbasic.lang.ModuleFactory;
import com.nestor.interpret.jbasic.lang.ParseContext;
import com.nestor.interpret.jbasic.lang.Stack;
import com.nestor.interpret.jbasic.parse.BlockBuilder;
import com.nestor.interpret.jbasic.parse.InterpretException;
import com.nestor.interpret.jbasic.profile.Configurator;
import com.nestor.interpret.jbasic.statement.Statement;
import com.nestor.interpret.parse.ParseEnv;
import com.nestor.interpret.parse.ParseException;
import com.nestor.interpret.parse.Scanner;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;

public final class JBasicCompiler {
    private final Configurator configurator;

    public JBasicCompiler(Configurator configurator) {
        this.configurator = configurator;
    }

    private Statement compile(String name, Scanner scanner, ParseContext context) throws ParseException {
        Statement statement;
        context.log("Parsing " + name);
        Stack stack = context.stack();
        stack.getClass();
        new Stack.Frame(stack, "MAIN-PARSING", Stack.BlockKind.TOPLEVEL);
        BlockBuilder block = new BlockBuilder(false);
        while ((statement = context.topLevelParser().parse(scanner, context)) != null) {
            block.addStatement(statement);
        }
        if (!scanner.end()) {
            throw scanner.expected(context.topLevelParser());
        }
        context.stack().popFrame();
        return block.getStatementNonNull();
    }

    public void compile(String name, Scanner scanner, ParseEnv env, OutputStream output) throws IOException, ParseException, InterpretException {
        JBasicProgram program = this.compile(name, scanner, env);
        env.log("Serializing " + name);
        ObjectOutputStream oos = output instanceof ObjectOutputStream ? (ObjectOutputStream)output : new ObjectOutputStream(output);
        oos.writeObject(program);
    }

    public JBasicProgram compile(String name, Scanner scanner, ParseEnv env) throws ParseException, InterpretException {
        ModuleBuilder moduleBuilder = ModuleFactory.prepareModuleBuilder(name, this.configurator);
        ParseContext context = new ParseContext(moduleBuilder, env, this.configurator);
        Statement body = this.compile(name, scanner, context);
        return new JBasicProgram(moduleBuilder.buildModule(body));
    }
}

