/*
 * Decompiled with CFR 0.152.
 */
package com.nestor.interpret.jbasic;

import com.nestor.interpret.expression.arithmetic.ArithmeticTokens;
import com.nestor.interpret.expression.arithmetic.NumberValueParser;
import com.nestor.interpret.expression.bool.BooleanTokens;
import com.nestor.interpret.expression.bool.BooleanValueParser;
import com.nestor.interpret.expression.relational.RelationalTokens;
import com.nestor.interpret.expression.string.StringValueParser;
import com.nestor.interpret.jbasic.parse.StatementParser;
import com.nestor.interpret.jbasic.parse.StatementTokens;
import com.nestor.interpret.jbasic.parse.SyntaxTokens;
import com.nestor.interpret.jbasic.profile.Configurator;
import com.nestor.interpret.parse.LineScanner;
import com.nestor.interpret.parse.ParseEnv;
import com.nestor.interpret.parse.Scanner;
import com.nestor.interpret.parse.Skip;
import com.nestor.interpret.token.StandardTokens;
import com.nestor.interpret.token.TokenContainer;
import java.io.Reader;
import java.lang.ref.SoftReference;

public class JBasicScannerFactory {
    private final Configurator configurator;
    private SoftReference<TokenContainer> tokensRef = null;
    private final ParseEnv env;

    public JBasicScannerFactory(Configurator configurator, ParseEnv env) {
        this.configurator = configurator;
        this.env = env;
    }

    public Scanner createQBasicScanner(Reader reader) {
        return new LineScanner(this.env, JBasicScannerFactory.getScannerSkip(), this.getTokenCollection(), reader);
    }

    public Scanner createQBasicScanner(String input) {
        return new LineScanner(this.env, JBasicScannerFactory.getScannerSkip(), this.getTokenCollection(), input);
    }

    private static Skip getScannerSkip() {
        return new Skip(){

            public boolean skip(char c) {
                return c == ' ' || c == '\t';
            }
        };
    }

    private synchronized TokenContainer getTokenCollection() {
        if (this.tokensRef == null || this.tokensRef.get() == null) {
            TokenContainer tokens = new TokenContainer();
            tokens.addTokens(BooleanTokens.class);
            tokens.addTokens(ArithmeticTokens.class);
            tokens.addTokens(RelationalTokens.class);
            tokens.addTokens(StandardTokens.class);
            tokens.addTokens(StatementTokens.class);
            tokens.addToken(NumberValueParser.DOUBLE_TOKEN);
            tokens.addToken(NumberValueParser.INTEGER_TOKEN);
            tokens.addToken(BooleanValueParser.BOOLEAN_TOKEN);
            tokens.addToken(StringValueParser.STRING_TOKEN);
            this.configurator.addTokens(tokens);
            tokens.addTokens(SyntaxTokens.class);
            tokens.addToken(StatementParser.EOL);
            this.tokensRef = new SoftReference<TokenContainer>(tokens);
            return this.tokensRef.get();
        }
        return this.tokensRef.get();
    }
}

