/*
 * Decompiled with CFR 0.152.
 */
package com.nestor.interpret.jbasic.lang;

import com.nestor.interpret.expression.EvaluationException;
import com.nestor.interpret.expression.Value;
import com.nestor.interpret.jbasic.lang.DeclarationException;
import com.nestor.interpret.jbasic.lang.Parameter;
import com.nestor.interpret.jbasic.lang.ParseContext;
import com.nestor.interpret.jbasic.lang.RuntimeContext;
import com.nestor.interpret.jbasic.statement.ReturnCode;
import com.nestor.interpret.jbasic.statement.Statement;
import com.nestor.interpret.type.DATA;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Callable<T extends Callable>
extends Statement {
    private static final long serialVersionUID = -7887059123645838008L;
    private Statement code;
    private final String name;
    private final List<Parameter> params;

    public Callable(String name, List<Parameter> params) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (params == null) {
            throw new NullPointerException("params");
        }
        this.name = name;
        this.params = params;
    }

    public Callable(String name, Parameter ... params) {
        this(name, Arrays.asList(params));
    }

    public abstract Statement createCall(List<Value<? extends DATA>> var1);

    public boolean declares(Callable decl) {
        if (!decl.name.equals(this.name)) {
            return false;
        }
        if (!Arrays.equals(decl.params.toArray(), decl.params.toArray())) {
            return false;
        }
        if (!this.getClass().isAssignableFrom(decl.getClass())) {
            return false;
        }
        return this.declaresSpecific(decl);
    }

    protected abstract boolean declaresSpecific(T var1);

    @Override
    public String describe() {
        return this.name;
    }

    @Override
    protected ReturnCode executeImpl(RuntimeContext context) throws EvaluationException {
        return this.code.execute(context);
    }

    public String getName() {
        return this.name;
    }

    public List<Parameter> getParameters() {
        return this.params;
    }

    public void implement(Statement implementation) {
        if (this.code != null) {
            throw new IllegalArgumentException("Cannot reimplement " + this.name);
        }
        this.code = implementation;
    }

    public boolean isImplemented() {
        return this.code != null;
    }

    public abstract Callable resolveDefinition(ParseContext var1) throws DeclarationException;
}

