/*
 * Decompiled with CFR 0.152.
 */
package com.nestor.interpret.jbasic.lang;

import com.nestor.interpret.jbasic.lang.RedeclarationException;
import com.nestor.interpret.jbasic.lang.UndeclaredIdentifierException;
import com.nestor.shared.Description;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CheckedContainer<E extends Description>
implements Serializable,
Iterable<E> {
    private static final long serialVersionUID = 2928996982350167471L;
    private final String elementDescription;
    private final boolean caseSensitive;
    private HashMap<String, E> elements = new HashMap();

    public CheckedContainer(String elementDescription, boolean caseSensitive) {
        this.elementDescription = elementDescription;
        this.caseSensitive = caseSensitive;
    }

    public void add(String identifier, E element) throws RedeclarationException {
        if (!this.caseSensitive) {
            identifier = identifier.toUpperCase();
        }
        if (this.elements.containsKey(identifier)) {
            throw new RedeclarationException(this.elementDescription, (Description)element);
        }
        this.elements.put(identifier, element);
    }

    public void addUnchecked(String identifier, E element) {
        if (!this.caseSensitive) {
            identifier = identifier.toUpperCase();
        }
        if (!this.elements.containsKey(identifier)) {
            this.elements.put(identifier, element);
        }
    }

    public boolean contains(String identifier) {
        if (!this.caseSensitive) {
            identifier = identifier.toUpperCase();
        }
        return this.elements.containsKey(identifier);
    }

    public E get(String identifier) throws UndeclaredIdentifierException {
        if (!this.caseSensitive) {
            identifier = identifier.toUpperCase();
        }
        if (!this.elements.containsKey(identifier)) {
            throw new UndeclaredIdentifierException(this.elementDescription);
        }
        return (E)((Description)this.elements.get(identifier));
    }

    public E getUnchecked(String identifier) {
        if (!this.caseSensitive) {
            identifier = identifier.toUpperCase();
        }
        return (E)((Description)this.elements.get(identifier));
    }

    @Override
    public Iterator<E> iterator() {
        Iterator<E> valueIterator = this.elements.values().iterator();
        return new Iterator<E>(valueIterator){
            private Iterator<E> iterator;
            {
                this.iterator = iterator;
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public E next() {
                return (Description)this.iterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public String toString() {
        return this.elements.toString();
    }
}

