/*
 * Decompiled with CFR 0.152.
 */
package com.nestor.interpret.jbasic.lang;

import com.nestor.interpret.expression.Value;
import com.nestor.interpret.jbasic.lang.Callable;
import com.nestor.interpret.jbasic.lang.DeclarationException;
import com.nestor.interpret.jbasic.lang.FunctionCall;
import com.nestor.interpret.jbasic.lang.Parameter;
import com.nestor.interpret.jbasic.lang.ParseContext;
import com.nestor.interpret.type.DATA;
import com.nestor.interpret.type.TYPE;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Function
extends Callable<Function> {
    private static final long serialVersionUID = 8972762777729928202L;
    private final TYPE<? extends DATA> returnType;

    public Function(String name, TYPE<? extends DATA> returnType, List<Parameter> params) {
        super(name, params);
        if (returnType == null) {
            throw new NullPointerException("returnType");
        }
        this.returnType = returnType;
    }

    public Function(String name, TYPE<? extends DATA> returnType, Parameter ... params) {
        this(name, returnType, Arrays.asList(params));
    }

    @Override
    public FunctionCall createCall(List<Value<? extends DATA>> arguments) {
        return new FunctionCall(this, arguments);
    }

    @Override
    public boolean declaresSpecific(Function decl) {
        return decl.returnType.equals(this.returnType);
    }

    public TYPE<? extends DATA> getReturnType() {
        return this.returnType;
    }

    @Override
    public Callable resolveDefinition(ParseContext context) throws DeclarationException {
        Function function = null;
        if (context.moduleBuilder().containsFunction(this.getName()) && this.declares(function = context.moduleBuilder().getFunction(this.getName()))) {
            return function;
        }
        context.moduleBuilder().addFunction(this);
        return this;
    }
}

