/*
 * Decompiled with CFR 0.152.
 */
package com.nestor.interpret.jbasic.lang;

import com.nestor.interpret.jbasic.lang.CheckedContainer;
import com.nestor.interpret.jbasic.lang.Constant;
import com.nestor.interpret.jbasic.lang.Function;
import com.nestor.interpret.jbasic.lang.Module;
import com.nestor.interpret.jbasic.lang.RedeclarationException;
import com.nestor.interpret.jbasic.lang.Sub;
import com.nestor.interpret.jbasic.lang.UndeclaredIdentifierException;
import com.nestor.interpret.jbasic.lang.Variable;
import com.nestor.interpret.jbasic.parse.InterpretException;
import com.nestor.interpret.jbasic.profile.Configurator;
import com.nestor.interpret.jbasic.statement.Statement;
import com.nestor.interpret.type.DATA;
import com.nestor.interpret.type.TYPE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModuleBuilder {
    private final CheckedContainer<Constant> constants;
    private final CheckedContainer<Function> functions;
    private final String name;
    private final CheckedContainer<Sub> subs;
    private final CheckedContainer<TYPE<? extends DATA>> types;
    private final CheckedContainer<Variable> variables;

    public ModuleBuilder(String name, Configurator config) {
        this.name = name;
        boolean caseSensitive = config.identifiersCaseSensitive();
        this.constants = new CheckedContainer("constant", caseSensitive);
        this.functions = new CheckedContainer("function", caseSensitive);
        this.subs = new CheckedContainer("sub", caseSensitive);
        this.types = new CheckedContainer("type", caseSensitive);
        this.variables = new CheckedContainer("variable", caseSensitive);
    }

    public void addConstant(Constant element) throws RedeclarationException {
        this.constants.add(element.getName(), element);
    }

    public void addFunction(Function element) throws RedeclarationException {
        this.functions.add(element.getName(), element);
    }

    public void addSub(Sub element) throws RedeclarationException {
        this.subs.add(element.getName(), element);
    }

    public void addType(TYPE<? extends DATA> type) throws RedeclarationException {
        this.types.add(type.getName(), type);
    }

    public void addVariable(Variable element) throws RedeclarationException {
        this.variables.add(element.getName(), element);
    }

    public Module buildModule(Statement mainBody) throws InterpretException {
        for (Sub sub : this.subs) {
            if (sub.isImplemented()) continue;
            throw new InterpretException("Sub '" + sub.describe() + "' is not implemented!");
        }
        for (Function function : this.functions) {
            if (function.isImplemented()) continue;
            throw new InterpretException("Function '" + function.describe() + "' is not implemented!");
        }
        return new Module(this.name, this.subs, this.functions, this.types, this.variables, mainBody);
    }

    public final boolean containsConstant(String identifier) {
        return this.constants.contains(identifier);
    }

    public final boolean containsFunction(String identifier) {
        return this.functions.contains(identifier);
    }

    public final boolean containsSub(String identifier) {
        return this.subs.contains(identifier);
    }

    public final boolean containsType(String identifier) {
        return this.types.contains(identifier);
    }

    public final boolean containsVariable(String identifier) {
        return this.variables.contains(identifier);
    }

    public Constant getConstant(String identifier) throws UndeclaredIdentifierException {
        return this.constants.get(identifier);
    }

    public Function getFunction(String identifier) throws UndeclaredIdentifierException {
        return this.functions.get(identifier);
    }

    public Sub getSub(String identifier) throws UndeclaredIdentifierException {
        return this.subs.get(identifier);
    }

    public TYPE<? extends DATA> getType(String identifier) throws UndeclaredIdentifierException {
        return this.types.get(identifier);
    }

    public Variable getVariable(String identifier) throws UndeclaredIdentifierException {
        return this.variables.get(identifier);
    }

    public final String toString() {
        return this.name;
    }
}

