/*
 * Decompiled with CFR 0.152.
 */
package com.nestor.interpret.jbasic.lang;

import com.nestor.interpret.expression.EvaluationException;
import com.nestor.interpret.expression.RuntimeEnv;
import com.nestor.interpret.jbasic.lang.Module;
import com.nestor.interpret.jbasic.lang.RuntimeStack;
import com.nestor.interpret.jbasic.profile.RuntimeServiceProvider;
import com.nestor.interpret.jbasic.profile.qbasic.parse.TextServices;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RuntimeContext
extends RuntimeServiceProvider<EvaluationException>
implements RuntimeEnv {
    private final Module module;
    private final RuntimeServiceProvider<? extends Throwable> serviceProvider;
    private Map<Class, Object> servicesMap = new HashMap<Class, Object>();
    private final RuntimeStack stack = new RuntimeStack();

    public RuntimeContext(RuntimeServiceProvider<? extends Throwable> rsp, Module module) {
        this.serviceProvider = rsp;
        this.module = module;
    }

    @Override
    public synchronized <S> S getRuntimeService(Class<S> serviceClass) throws EvaluationException {
        if (this.servicesMap.containsKey(serviceClass)) {
            return (S)this.servicesMap.get(serviceClass);
        }
        try {
            S service = this.serviceProvider.getRuntimeService(serviceClass);
            if (service == null) {
                throw new EvaluationException("Runtime service " + serviceClass + " could not be instantiated");
            }
            this.servicesMap.put(serviceClass, service);
            return service;
        }
        catch (Throwable e) {
            throw new EvaluationException("Runtime service " + serviceClass + " could not be instantiated", e);
        }
    }

    @Override
    public void log(String message) {
        try {
            Object logSrv = this.getRuntimeService(TextServices.class.getName());
            Method logMth = logSrv.getClass().getMethod("log", String.class);
            logMth.invoke(logSrv, message);
        }
        catch (EvaluationException evaluationException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Module module() {
        return this.module;
    }

    public RuntimeStack stack() {
        return this.stack;
    }
}

