/*
 * Decompiled with CFR 0.152.
 */
package com.nestor.interpret.jbasic.lang;

import com.nestor.interpret.jbasic.lang.CheckedContainer;
import com.nestor.interpret.jbasic.lang.RedeclarationException;
import com.nestor.interpret.jbasic.lang.UndeclaredIdentifierException;
import com.nestor.interpret.jbasic.lang.Variable;

public class Stack {
    final java.util.Stack<Frame> frames = new java.util.Stack();
    final boolean caseSensitive;

    public Stack(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public final Block blockEnd() {
        return this.frames.peek().blocks.pop();
    }

    public final boolean containsVariable(String identifier) {
        java.util.Stack<Block> blocks = this.frames.peek().blocks;
        for (Block block : blocks) {
            if (!block.variables.contains(identifier)) continue;
            return true;
        }
        return false;
    }

    public final Block findBlock(BlockKind bt) {
        java.util.Stack<Block> blocks = this.frames.peek().blocks;
        int i = blocks.size() - 1;
        while (i >= 0) {
            Block block = (Block)blocks.get(i);
            if (block.type == bt) {
                return block;
            }
            if (((Object)((Object)bt)).getClass().isInstance((Object)block.type)) {
                return block;
            }
            --i;
        }
        return null;
    }

    final Block findBlockContainingVariable(String identifier) {
        java.util.Stack<Block> blocks = this.frames.peek().blocks;
        for (Block block : blocks) {
            if (!block.variables.contains(identifier)) continue;
            return block;
        }
        return null;
    }

    public final Block getCurrentBlock() {
        return this.frames.peek().blocks.peek();
    }

    public final String getCurrentFrameName() {
        return this.frames.peek().callName;
    }

    public final void popFrame() {
        this.frames.pop();
    }

    public void addVariable(Variable variable) throws RedeclarationException {
        this.getCurrentBlock().variables.add(variable.getName(), variable);
    }

    public Variable getVariable(String identifier) throws UndeclaredIdentifierException {
        Block block2 = this.findBlockContainingVariable(identifier);
        if (block2 != null) {
            return block2.variables.get(identifier);
        }
        return null;
    }

    public class Block {
        final BlockKind type;
        final CheckedContainer<Variable> variables;

        public Block(BlockKind type) {
            this.type = type;
            this.variables = new CheckedContainer("variable", Stack.this.caseSensitive);
            Stack.this.frames.peek().blocks.push(this);
        }

        public final BlockKind getType() {
            return this.type;
        }

        public final String toString() {
            return this.variables.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BlockKind {
        CODE,
        FOR,
        FUNCTION,
        IF,
        SUB,
        TOPLEVEL,
        DOWHILE;

    }

    public final class ForBlock
    extends Block {
        private final String counterVariableName;

        public ForBlock(String counterVariableName) {
            super(BlockKind.FOR);
            if (counterVariableName == null) {
                throw new NullPointerException("counterVariableName");
            }
            this.counterVariableName = counterVariableName;
        }

        public String getCounterVariableName() {
            return this.counterVariableName;
        }
    }

    public final class Frame {
        final java.util.Stack<Block> blocks = new java.util.Stack();
        final String callName;

        public Frame(String callName, BlockKind blockType) {
            if (callName == null) {
                throw new IllegalArgumentException("callName");
            }
            if (blockType == null) {
                throw new IllegalArgumentException("blockType");
            }
            this.callName = callName;
            Stack.this.frames.push(this);
            Stack stack2 = Stack.this;
            stack2.getClass();
            stack2.new Block(blockType);
        }

        public String toString() {
            return this.blocks.toString();
        }
    }
}

