/*
 * Decompiled with CFR 0.152.
 */
package com.nestor.interpret.jbasic.lang;

import com.nestor.interpret.expression.EvaluationException;
import com.nestor.interpret.expression.RuntimeEnv;
import com.nestor.interpret.expression.Value;
import com.nestor.interpret.type.DATA;
import com.nestor.interpret.type.INTEGER;
import com.nestor.interpret.type.TYPE;
import com.nestor.interpret.type.TYPES;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Variable
implements Value<DATA> {
    public static final TYPE<INTEGER> DEFAULT_TYPE = TYPES.INTEGER_TYPE;
    private static final long serialVersionUID = -4889453452393374168L;
    private final String name;
    private DATA value;
    private final TYPE<? extends DATA> variableType;

    public Variable(String name, TYPE<? extends DATA> variableClass) {
        this.name = name;
        this.variableType = variableClass;
        this.value = variableClass.newInstance();
    }

    @Override
    public String describe() {
        return String.valueOf(this.name) + "[" + this.variableType.describe() + "]";
    }

    @Override
    public DATA evaluate(RuntimeEnv env) throws EvaluationException {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public TYPE<? extends DATA> getValueType() {
        return this.variableType;
    }

    public void setValue(DATA newValue) {
        if (newValue != null && !this.variableType.isInstance(newValue)) {
            throw new IllegalArgumentException("Incompatible value type: got " + newValue.getValueType().describe() + " expected " + this.variableType.describe());
        }
        this.value = newValue;
    }

    public String toString() {
        return this.describe();
    }
}

