/*
 * Decompiled with CFR 0.152.
 */
package com.nestor.interpret.jbasic.libs;

import com.nestor.interpret.expression.EvaluationException;
import com.nestor.interpret.jbasic.lang.DeclarationException;
import com.nestor.interpret.jbasic.lang.Function;
import com.nestor.interpret.jbasic.lang.ModuleBuilder;
import com.nestor.interpret.jbasic.lang.Parameter;
import com.nestor.interpret.jbasic.lang.RedeclarationException;
import com.nestor.interpret.jbasic.lang.RuntimeContext;
import com.nestor.interpret.jbasic.libs.AbstractFunction;
import com.nestor.interpret.jbasic.libs.AbstractLibrary;
import com.nestor.interpret.jbasic.statement.ReturnCode;
import com.nestor.interpret.type.DOUBLE;
import com.nestor.interpret.type.INTEGER;
import com.nestor.interpret.type.NUMBER;
import com.nestor.interpret.type.STRING;
import com.nestor.interpret.type.TYPES;

public class Numbers
extends AbstractLibrary {
    public void load(ModuleBuilder program) throws DeclarationException {
        Numbers.loadStatic(program);
    }

    private static void loadStatic(ModuleBuilder program) throws RedeclarationException {
        final Parameter arg = new Parameter("x", TYPES.NUMBER_TYPE);
        final Function fn = new Function("CLNG", TYPES.INTEGER_TYPE, arg);
        fn.implement(new AbstractFunction(fn){
            private static final long serialVersionUID = -3906963767908180552L;

            protected ReturnCode executeImpl(RuntimeContext context) throws EvaluationException {
                NUMBER x = (NUMBER)context.stack().getVariable(arg.getName()).evaluate(context);
                context.stack().getVariable(fn.getName()).setValue(new INTEGER(x.intValue()));
                return ReturnCode.SUCCESS;
            }
        });
        program.addFunction(fn);
        arg = new Parameter("x", TYPES.NUMBER_TYPE);
        fn = new Function("CINT", TYPES.INTEGER_TYPE, arg);
        fn.implement(new AbstractFunction(fn){
            private static final long serialVersionUID = -3906963767908180552L;

            protected ReturnCode executeImpl(RuntimeContext context) throws EvaluationException {
                NUMBER x = (NUMBER)context.stack().getVariable(arg.getName()).evaluate(context);
                context.stack().getVariable(fn.getName()).setValue(new INTEGER(x.intValue()));
                return ReturnCode.SUCCESS;
            }
        });
        program.addFunction(fn);
        arg = new Parameter("x", TYPES.DOUBLE_TYPE);
        fn = new Function("INT", TYPES.INTEGER_TYPE, arg);
        fn.implement(new AbstractFunction(fn){
            private static final long serialVersionUID = -3906963767908180552L;

            protected ReturnCode executeImpl(RuntimeContext context) throws EvaluationException {
                DOUBLE x = (DOUBLE)context.stack().getVariable(arg.getName()).evaluate(context);
                context.stack().getVariable(fn.getName()).setValue(new INTEGER(x.intValue()));
                return ReturnCode.SUCCESS;
            }
        });
        program.addFunction(fn);
        arg = new Parameter("str", TYPES.STRING_TYPE);
        fn = new Function("VAL", TYPES.DOUBLE_TYPE, arg);
        fn.implement(new AbstractFunction(fn){
            private static final long serialVersionUID = -3906963767908180552L;

            protected ReturnCode executeImpl(RuntimeContext context) throws EvaluationException {
                double d;
                STRING str = (STRING)context.stack().getVariable(arg.getName()).evaluate(context);
                try {
                    d = Double.parseDouble(str.stringValue());
                }
                catch (NumberFormatException e) {
                    d = 0.0;
                }
                context.stack().getVariable(fn.getName()).setValue(new DOUBLE(d));
                return ReturnCode.SUCCESS;
            }
        });
        program.addFunction(fn);
    }
}

