/*
 * Decompiled with CFR 0.152.
 */
package com.nestor.interpret.jbasic.parse;

import com.nestor.interpret.expression.ParenthesisParser;
import com.nestor.interpret.expression.RefinedValueParser;
import com.nestor.interpret.expression.Value;
import com.nestor.interpret.expression.arithmetic.ArithmeticParser;
import com.nestor.interpret.expression.bool.SequentialBooleanEquationParser;
import com.nestor.interpret.expression.relational.RelationalExpressionParser;
import com.nestor.interpret.expression.string.StringParser;
import com.nestor.interpret.parse.ChoiceParser;
import com.nestor.interpret.parse.ParseEnv;
import com.nestor.interpret.parse.ParseException;
import com.nestor.interpret.parse.Parser;
import com.nestor.interpret.parse.ParserDelegate;
import com.nestor.interpret.parse.Scanner;
import com.nestor.interpret.type.DATA;
import com.nestor.interpret.type.PromotionNotSupportedException;
import com.nestor.interpret.type.TYPE;
import com.nestor.interpret.type.ValuePromotor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ExpressionValueParser<VAL extends DATA>
extends RefinedValueParser<VAL> {
    ExpressionValueParser(TYPE<? extends VAL> valueType) {
        this(valueType, (Parser<Value>)null);
    }

    public ExpressionValueParser(TYPE<? extends VAL> valueType, Parser<Value> valueParser) {
        super(valueType, null);
        ParserDelegate<Value> delegate = new ParserDelegate<Value>();
        ParenthesisParser parenthesisParser = new ParenthesisParser(delegate);
        ChoiceParser<Value<Object>> baseParser = new ChoiceParser<Value<Object>>("value");
        baseParser.addParser(valueParser);
        baseParser.addParser(parenthesisParser);
        ArithmeticParser arithmeticParser = new ArithmeticParser(baseParser);
        RelationalExpressionParser relationalParser = new RelationalExpressionParser(arithmeticParser);
        StringParser stringParser = new StringParser(relationalParser);
        SequentialBooleanEquationParser booleanParser = new SequentialBooleanEquationParser(stringParser);
        delegate.setDelegate(booleanParser);
        super.changeSubparser(delegate);
    }

    @Override
    public String describe() {
        return "value of type " + super.getValueClass().describe();
    }

    @Override
    public Value<VAL> parse(Scanner scanner, ParseEnv env) throws ParseException {
        ParseException exception = scanner.expected(this);
        Value match = (Value)super.seekCompatibleMatch(scanner, env);
        if (match == null) {
            return null;
        }
        Value value = super.castIfValueCompatible(match);
        if (value == null) {
            try {
                return ValuePromotor.createPromotor(match, this.getValueClass());
            }
            catch (PromotionNotSupportedException e) {
                exception.fillInStackTrace();
                throw exception;
            }
        }
        return value;
    }
}

