/*
 * Decompiled with CFR 0.152.
 */
package com.nestor.interpret.jbasic.parse;

import com.nestor.interpret.expression.Value;
import com.nestor.interpret.expression.relational.RelationalTokens;
import com.nestor.interpret.jbasic.lang.DeclarationException;
import com.nestor.interpret.jbasic.lang.ParseContext;
import com.nestor.interpret.jbasic.lang.Stack;
import com.nestor.interpret.jbasic.lang.VariableAccessor;
import com.nestor.interpret.jbasic.parse.StatementParser;
import com.nestor.interpret.jbasic.parse.StatementTokens;
import com.nestor.interpret.jbasic.parse.SyntaxTokens;
import com.nestor.interpret.jbasic.statement.ForNextStatement;
import com.nestor.interpret.jbasic.statement.ForStatement;
import com.nestor.interpret.jbasic.statement.Statement;
import com.nestor.interpret.parse.ParseException;
import com.nestor.interpret.parse.Scanner;
import com.nestor.interpret.type.DATA;
import com.nestor.interpret.type.NUMBER;
import com.nestor.interpret.type.PromotionNotSupportedException;
import com.nestor.interpret.type.TYPE;
import com.nestor.interpret.type.TYPES;
import com.nestor.interpret.type.ValuePromotor;

final class ForParser
extends StatementParser {
    ForParser() {
        super(false);
    }

    protected Statement parseStatement(Scanner scanner, ParseContext context) throws ParseException, DeclarationException {
        if (scanner.matchAdvance(StatementTokens.FOR) == null) {
            return null;
        }
        ParseException expectedNumber = scanner.expected("numeric variable");
        String identifier = scanner.required(SyntaxTokens.IDENTIFIER);
        scanner.required(RelationalTokens.EQUAL);
        Value<DATA> from = context.parseHelper().requireValue(scanner, TYPES.NUMBER_TYPE);
        scanner.required(StatementTokens.TO);
        Value<DATA> to = context.parseHelper().requireValue(scanner, TYPES.NUMBER_TYPE);
        TYPE<NUMBER> bestBaseType = NUMBER.getBestBaseType(from.getValueType(), to.getValueType());
        VariableAccessor var = context.parseHelper().parseVariableAccess(scanner, identifier, bestBaseType);
        if (!TYPES.NUMBER_TYPE.isAssignableFrom(var.getValueType())) {
            expectedNumber.fillInStackTrace();
            throw expectedNumber;
        }
        try {
            from = ValuePromotor.createPromotor(from, var.getValueType());
            to = ValuePromotor.createPromotor(to, var.getValueType());
        }
        catch (PromotionNotSupportedException e) {
            throw scanner.parseFailure(e);
        }
        Value<? extends DATA> step = null;
        if (scanner.matchAdvance(StatementTokens.STEP) != null) {
            step = context.parseHelper().requireValue(scanner, var.getValueType());
        }
        super.requireEOL(scanner);
        Stack stack = context.stack();
        stack.getClass();
        stack.new Stack.ForBlock(identifier);
        Statement loop = context.parseHelper().requireStatementBlock(scanner, ForNextStatement.class);
        context.stack().blockEnd();
        return new ForStatement(loop, var, from, to, step);
    }
}

